/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.phase.PhaseHandler;
import forge.gamemodes.match.input.InputSyncronizedBase;
import forge.gui.control.FControlGamePlayback;
import forge.gui.control.PlaybackSpeed;

public class InputPlaybackControl
extends InputSyncronizedBase {
    private static final long serialVersionUID = 7979208993306642072L;
    final FControlGamePlayback control;
    private boolean isPaused = false;
    private PlaybackSpeed speed = PlaybackSpeed.NORMAL;
    private final Game game;
    private int currentTurn;

    public InputPlaybackControl(Game game0, FControlGamePlayback fControlGamePlayback) {
        super(fControlGamePlayback.getController());
        this.game = game0;
        this.control = fControlGamePlayback;
        this.setPause(false);
    }

    @Override
    protected void showMessage() {
        this.setPause(false);
    }

    public void updateTurnMessage() {
        if (this.isPaused) {
            this.showMessage(this.getTurnPhasePriorityMessage(this.game));
            this.currentTurn = 0;
        } else {
            PhaseHandler ph = this.game.getPhaseHandler();
            if (this.currentTurn == ph.getTurn()) {
                return;
            }
            this.currentTurn = ph.getTurn();
            this.showMessage("Turn " + this.currentTurn + " (" + ph.getPlayerTurn() + ")");
        }
    }

    private void setPause(boolean pause) {
        this.isPaused = pause;
        if (this.isPaused) {
            this.getController().getGui().updateButtons(null, "Resume", "Step", true, true, true);
        } else {
            this.getController().getGui().updateButtons(null, "Pause", this.speed.nextSpeedText(), true, true, true);
        }
        this.getController().getGui().setgamePause(this.isPaused);
    }

    public void pause() {
        if (this.isPaused) {
            return;
        }
        this.control.pause();
        this.setPause(true);
    }

    @Override
    protected void onOk() {
        if (this.isPaused) {
            this.control.resume();
            this.setPause(false);
        } else {
            this.control.pause();
            this.setPause(true);
        }
    }

    @Override
    protected void onCancel() {
        if (this.isPaused) {
            this.control.singleStep();
        } else {
            this.speed = this.speed.nextSpeed();
            this.control.setSpeed(this.speed);
            this.getController().getGui().setGameSpeed(this.speed);
            this.setPause(this.isPaused);
        }
    }

    @Override
    public String getActivateAction(Card card) {
        return null;
    }
}

