/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import forge.card.mana.ManaCostShard;
import forge.game.mana.Mana;
import forge.game.mana.ManaConversionMatrix;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.gamemodes.match.input.InputPayMana;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.PlayerControllerHuman;
import forge.util.ITriggerEvent;
import forge.util.Localizer;
import java.util.ArrayList;

public class InputPayManaOfCostPayment
extends InputPayMana {
    private static final long serialVersionUID = 3467312982164195091L;
    private ManaConversionMatrix extraMatrix;

    public InputPayManaOfCostPayment(PlayerControllerHuman controller, ManaCostBeingPaid cost, SpellAbility spellAbility, Player payer, ManaConversionMatrix matrix, boolean effect) {
        super(controller, spellAbility, payer, effect);
        this.manaCost = cost;
        this.extraMatrix = matrix;
        this.applyMatrix();
        if (spellAbility.getPayCosts().isMandatory()) {
            ArrayList<Mana> refund = new ArrayList<Mana>();
            this.mandatory = payer.getManaPool().payManaCostFromPool(new ManaCostBeingPaid(cost), spellAbility, true, refund);
            payer.getManaPool().refundMana(refund);
        }
        this.player.pushPaidForSA(this.saPaidFor);
        this.saPaidFor.setManaCostBeingPaid(this.manaCost);
    }

    @Override
    protected final void onPlayerSelected(Player selected, ITriggerEvent triggerEvent) {
        if (this.player == selected) {
            if (this.player.canPayLife(this.phyLifeToLose + 2, this.effect, this.saPaidFor)) {
                if (this.manaCost.payPhyrexian()) {
                    this.saPaidFor.setSpendPhyrexianMana(true);
                    this.phyLifeToLose += 2;
                } else if (this.player.hasKeyword("PayLifeInsteadOf:B") && this.manaCost.hasAnyKind(4)) {
                    this.manaCost.decreaseShard(ManaCostShard.BLACK, 1);
                    this.phyLifeToLose += 2;
                }
            }
            this.showMessage();
        }
    }

    @Override
    protected void done() {
        if (this.phyLifeToLose > 0) {
            this.player.payLife(this.phyLifeToLose, this.saPaidFor, this.effect);
        }
    }

    @Override
    protected void onCancel() {
        this.stop();
    }

    @Override
    protected String getMessage() {
        boolean isLifeInsteadBlack;
        String displayMana = this.manaCost.toString(false, this.player.getManaPool());
        StringBuilder msg = new StringBuilder();
        Localizer localizer = Localizer.getInstance();
        this.applyMatrix();
        if (this.messagePrefix != null) {
            msg.append(this.messagePrefix).append("\n");
        }
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_DETAILED_SPELLDESC_IN_PROMPT)) {
            if (this.saPaidFor.isSpell()) {
                msg.append(this.saPaidFor.getStackDescription().replace("(Targeting ERROR)", "")).append("\n\n");
            } else {
                msg.append(this.saPaidFor.getHostCard()).append(" - ").append(this.saPaidFor.toString()).append("\n\n");
            }
        }
        msg.append(localizer.getMessage("lblPayManaCost", new Object[0])).append(" ").append(displayMana);
        if (this.phyLifeToLose > 0) {
            msg.append(" ").append(String.format(localizer.getMessage("lblLifePaidForPhyrexianMana", new Object[0]), this.phyLifeToLose));
        }
        boolean bl = isLifeInsteadBlack = this.player.hasKeyword("PayLifeInsteadOf:B") && this.manaCost.hasAnyKind(4);
        if (this.manaCost.containsPhyrexianMana() || isLifeInsteadBlack) {
            StringBuilder sb = new StringBuilder();
            if (this.manaCost.containsPhyrexianMana() && !isLifeInsteadBlack) {
                sb.append(localizer.getMessage("lblClickOnYourLifeTotalToPayLifeForPhyrexianMana", new Object[0]));
            } else if (!this.manaCost.containsPhyrexianMana() && isLifeInsteadBlack) {
                sb.append(localizer.getMessage("lblClickOnYourLifeTotalToPayLifeForBlackMana", new Object[0]));
            } else if (this.manaCost.containsPhyrexianMana() && isLifeInsteadBlack) {
                sb.append(localizer.getMessage("lblClickOnYourLifeTotalToPayLifeForPhyrexianOrBlackMana", new Object[0]));
            }
            msg.append("\n(").append((CharSequence)sb).append(")");
        }
        return msg.toString();
    }

    private void applyMatrix() {
        if (this.extraMatrix == null) {
            return;
        }
        this.player.getManaPool().applyCardMatrix(this.extraMatrix);
    }
}

