/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.player.actions.PassPriorityAction;
import forge.game.spellability.SpellAbility;
import forge.gamemodes.match.input.InputSyncronizedBase;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.player.PlayerControllerHuman;
import forge.util.ITriggerEvent;
import forge.util.Localizer;
import forge.util.ThreadUtil;
import java.util.ArrayList;
import java.util.List;

public class InputPassPriority
extends InputSyncronizedBase {
    private static final long serialVersionUID = -581477682214137181L;
    private List<SpellAbility> chosenSa;

    public InputPassPriority(PlayerControllerHuman controller) {
        super(controller);
    }

    @Override
    public final void showMessage() {
        this.showMessage(this.getTurnPhasePriorityMessage(this.getController().getGame()));
        this.chosenSa = null;
        Localizer localizer = Localizer.getInstance();
        if (this.getController().canUndoLastAction()) {
            this.getController().getGui().updateButtons(this.getOwner(), localizer.getMessage("lblOK", new Object[0]), localizer.getMessage("lblUndo", new Object[0]), true, true, true);
        } else {
            this.getController().getGui().updateButtons(this.getOwner(), localizer.getMessage("lblOK", new Object[0]), localizer.getMessage("lblEndTurn", new Object[0]), true, true, true);
        }
        this.getController().getGui().alertUser();
    }

    @Override
    protected final void onOk() {
        this.passPriority(() -> {
            this.getController().macros().addRememberedAction(new PassPriorityAction());
            this.stop();
        });
    }

    @Override
    protected final void onCancel() {
        if (!this.getController().tryUndoLastAction()) {
            this.passPriority(() -> {
                this.getController().autoPassUntilEndOfTurn();
                this.stop();
            });
        }
    }

    @Override
    protected boolean allowAwaitNextInput() {
        return this.chosenSa == null && !this.getController().mayAutoPass();
    }

    private void passPriority(Runnable runnable) {
        Player player;
        Game game;
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_MANA_LOST_PROMPT) && (game = this.getController().getGame()).getStack().isEmpty() && (player = game.getPhaseHandler().getPriorityPlayer()) != null && player.getManaPool().willManaBeLostAtEndOfPhase() && player.getLobbyPlayer() == GamePlayerUtil.getGuiPlayer()) {
            ThreadUtil.invokeInGameThread(() -> {
                Localizer localizer = Localizer.getInstance();
                String message = localizer.getMessage("lblYouHaveManaFloatingInYourManaPoolCouldBeLostIfPassPriority", new Object[0]);
                if (player.getManaPool().hasBurn()) {
                    message = message + " " + localizer.getMessage("lblYouWillTakeManaBurnDamageEqualAmountFloatingManaLostThisWay", new Object[0]);
                }
                if (this.getController().getGui().showConfirmDialog(message, localizer.getMessage("lblManaFloating", new Object[0]), localizer.getMessage("lblOK", new Object[0]), localizer.getMessage("lblCancel", new Object[0]))) {
                    runnable.run();
                }
            });
            return;
        }
        runnable.run();
    }

    public List<SpellAbility> getChosenSa() {
        return this.chosenSa;
    }

    @Override
    protected final void onPlayerSelected(Player selected, ITriggerEvent triggerEvent) {
        PlayerController pc = selected.getController();
        if (pc.isGuiPlayer()) {
            pc.setFullControl(!pc.isFullControl());
        }
    }

    @Override
    protected boolean onCardSelected(Card card, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
        List<SpellAbility> abilities = card.getAllPossibleAbilities(this.getController().getPlayer(), triggerEvent == null);
        if (abilities.isEmpty()) {
            return false;
        }
        SpellAbility ability = this.getController().getAbilityToPlay(card, abilities, triggerEvent);
        if (ability != null) {
            this.chosenSa = new ArrayList<SpellAbility>();
            this.chosenSa.add(ability);
            if (otherCardsToSelect != null && ability.isManaAbility()) {
                String abStr = ability.toUnsuppressedString();
                block0: for (Card c : otherCardsToSelect) {
                    for (SpellAbility ab : c.getAllPossibleAbilities(this.getController().getPlayer(), true)) {
                        if (!ab.toUnsuppressedString().equals(abStr)) continue;
                        this.chosenSa.add(ab);
                        continue block0;
                    }
                }
            }
            this.stop();
        }
        return true;
    }

    @Override
    public String getActivateAction(Card card) {
        List<SpellAbility> abilities = card.getAllPossibleAbilities(this.getController().getPlayer(), true);
        if (abilities.isEmpty()) {
            return null;
        }
        SpellAbility sa = abilities.get(0);
        if (sa.isSpell()) {
            return Localizer.getInstance().getMessage("lblCastSpell", new Object[0]);
        }
        if (sa.isLandAbility()) {
            return Localizer.getInstance().getMessage("lblPlayLand", new Object[0]);
        }
        return Localizer.getInstance().getMessage("lblActivateAbility", new Object[0]);
    }

    @Override
    public boolean selectAbility(SpellAbility ab) {
        if (ab != null) {
            this.chosenSa = new ArrayList<SpellAbility>();
            this.chosenSa.add(ab);
            this.stop();
            return true;
        }
        return false;
    }
}

