/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import com.google.common.collect.ImmutableList;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.spellability.SpellAbility;
import forge.gamemodes.match.input.InputSyncronizedBase;
import forge.gui.GuiBase;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.PlayerControllerHuman;
import forge.util.Localizer;
import java.util.List;

public class InputConfirm
extends InputSyncronizedBase {
    private static final long serialVersionUID = -3591794991788531626L;
    private final String message;
    private final String yesButtonText;
    private final String noButtonText;
    private final boolean defaultYes;
    private boolean result;
    private SpellAbility sa;
    private CardView card;
    private final boolean showDiffCard;
    protected static ImmutableList<String> defaultOptions = ImmutableList.of(Localizer.getInstance().getMessage("lblYes", new Object[0]), Localizer.getInstance().getMessage("lblNo", new Object[0]));

    public static boolean confirm(PlayerControllerHuman controller, CardView card, String message) {
        return InputConfirm.confirm(controller, card, message, true, defaultOptions);
    }

    public static boolean confirm(PlayerControllerHuman controller, CardView card, String message, boolean defaultIsYes, List<String> options) {
        if (GuiBase.getInterface().isLibgdxPort()) {
            return controller.getGui().confirm(card, message, defaultIsYes, options);
        }
        InputConfirm inp = options.size() == 2 ? new InputConfirm(controller, message, options.get(0), options.get(1), defaultIsYes, card) : new InputConfirm(controller, message, (String)defaultOptions.get(0), (String)defaultOptions.get(1), defaultIsYes, card);
        inp.showAndWait();
        return inp.getResult();
    }

    public static boolean confirm(PlayerControllerHuman controller, SpellAbility sa, String message) {
        return InputConfirm.confirm(controller, sa, message, true, defaultOptions);
    }

    public static boolean confirm(PlayerControllerHuman controller, SpellAbility sa, String message, boolean defaultIsYes, List<String> options) {
        if (GuiBase.getInterface().isLibgdxPort()) {
            if (sa == null) {
                return controller.getGui().confirm(null, message, defaultIsYes, options);
            }
            if (sa.getTargets() != null && sa.getTargets().isTargetingAnyCard() && sa.getTargets().size() == 1) {
                return controller.getGui().confirm(sa.getTargetCard() == null ? null : CardView.get(sa.getTargetCard()), message, defaultIsYes, options);
            }
            return controller.getGui().confirm(CardView.get(sa.getHostCard()), message, defaultIsYes, options);
        }
        InputConfirm inp = options.size() == 2 ? new InputConfirm(controller, message, options.get(0), options.get(1), defaultIsYes, sa) : new InputConfirm(controller, message, (String)defaultOptions.get(0), (String)defaultOptions.get(1), defaultIsYes, sa);
        inp.showAndWait();
        return inp.getResult();
    }

    public static boolean confirm(PlayerControllerHuman controller, CardView card, SpellAbility sa, String message) {
        return InputConfirm.confirm(controller, card, sa, message, true, defaultOptions);
    }

    public static boolean confirm(PlayerControllerHuman controller, CardView card, SpellAbility sa, String message, boolean defaultIsYes, List<String> options) {
        if (GuiBase.getInterface().isLibgdxPort()) {
            return controller.getGui().confirm(card, message, defaultIsYes, options);
        }
        InputConfirm inp = options.size() == 2 ? new InputConfirm(controller, message, options.get(0), options.get(1), defaultIsYes, card, sa) : new InputConfirm(controller, message, (String)defaultOptions.get(0), (String)defaultOptions.get(1), defaultIsYes, card, sa);
        inp.showAndWait();
        return inp.getResult();
    }

    public InputConfirm(PlayerControllerHuman controller, String message0) {
        this(controller, message0, Localizer.getInstance().getMessage("lblYes", new Object[0]), Localizer.getInstance().getMessage("lblNo", new Object[0]), true);
    }

    public InputConfirm(PlayerControllerHuman controller, String message0, String yesButtonText0, String noButtonText0) {
        this(controller, message0, yesButtonText0, noButtonText0, true);
    }

    public InputConfirm(PlayerControllerHuman controller, String message0, String yesButtonText0, String noButtonText0, boolean defaultYes0) {
        super(controller);
        this.message = message0;
        this.yesButtonText = yesButtonText0;
        this.noButtonText = noButtonText0;
        this.defaultYes = defaultYes0;
        this.result = defaultYes0;
        this.sa = null;
        this.card = null;
        this.showDiffCard = false;
    }

    public InputConfirm(PlayerControllerHuman controller, String message0, SpellAbility sa0) {
        this(controller, message0, Localizer.getInstance().getMessage("lblYes", new Object[0]), Localizer.getInstance().getMessage("lblNo", new Object[0]), true, sa0);
    }

    public InputConfirm(PlayerControllerHuman controller, String message0, String yesButtonText0, String noButtonText0, SpellAbility sa0) {
        this(controller, message0, yesButtonText0, noButtonText0, true, sa0);
    }

    public InputConfirm(PlayerControllerHuman controller, String message0, String yesButtonText0, String noButtonText0, boolean defaultYes0, SpellAbility sa0) {
        super(controller);
        this.message = message0;
        this.yesButtonText = yesButtonText0;
        this.noButtonText = noButtonText0;
        this.defaultYes = defaultYes0;
        this.result = defaultYes0;
        this.sa = sa0;
        this.card = this.sa != null ? this.sa.getView().getHostCard() : null;
        this.showDiffCard = false;
    }

    public InputConfirm(PlayerControllerHuman controller, String message0, CardView card0) {
        this(controller, message0, Localizer.getInstance().getMessage("lblYes", new Object[0]), Localizer.getInstance().getMessage("lblNo", new Object[0]), true, card0);
    }

    public InputConfirm(PlayerControllerHuman controller, String message0, String yesButtonText0, String noButtonText0, CardView card0) {
        this(controller, message0, yesButtonText0, noButtonText0, true, card0);
    }

    public InputConfirm(PlayerControllerHuman controller, String message0, String yesButtonText0, String noButtonText0, boolean defaultYes0, CardView card0) {
        super(controller);
        this.message = message0;
        this.yesButtonText = yesButtonText0;
        this.noButtonText = noButtonText0;
        this.defaultYes = defaultYes0;
        this.result = defaultYes0;
        this.sa = null;
        this.card = card0;
        this.showDiffCard = false;
    }

    public InputConfirm(PlayerControllerHuman controller, String message0, String yesButtonText0, String noButtonText0, boolean defaultYes0, CardView card0, SpellAbility sa0) {
        super(controller);
        this.message = message0;
        this.yesButtonText = yesButtonText0;
        this.noButtonText = noButtonText0;
        this.defaultYes = defaultYes0;
        this.result = defaultYes0;
        this.sa = sa0;
        this.card = card0;
        this.showDiffCard = true;
    }

    @Override
    protected final void showMessage() {
        this.getController().getGui().updateButtons(this.getOwner(), this.yesButtonText, this.noButtonText, true, true, this.defaultYes);
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_DETAILED_SPELLDESC_IN_PROMPT) && this.card != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.showDiffCard ? this.sa.getHostCard().toString() : this.card.toString());
            if (this.sa != null && this.sa.toString().length() > 1) {
                sb.append(" - ").append(this.sa.toString());
            }
            sb.append("\n\n").append(this.message);
            this.showMessage(sb.toString(), this.card);
        } else if (this.card != null) {
            this.showMessage(this.message, this.card);
        } else {
            this.showMessage(this.message);
        }
    }

    @Override
    protected final void onOk() {
        this.result = true;
        this.done();
    }

    @Override
    protected final void onCancel() {
        this.result = false;
        this.done();
    }

    private void done() {
        this.stop();
    }

    public final boolean getResult() {
        return this.result;
    }

    @Override
    public String getActivateAction(Card card) {
        return null;
    }
}

