/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.zone.PlayerZone;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.input.InputSyncronizedBase;
import forge.player.PlayerControllerHuman;
import java.util.ArrayList;
import java.util.Deque;

public class InputChooseStartingHand
extends InputSyncronizedBase {
    private final Deque<PlayerZone> hands;
    PlayerZone primaryHand = null;
    Game game;

    public InputChooseStartingHand(PlayerControllerHuman controller, Player humanPlayer) {
        super(controller);
        this.game = humanPlayer.getGame();
        this.primaryHand = humanPlayer.getZone(ZoneType.Hand);
        this.hands = Lists.newLinkedList();
        for (PlayerZone extraHand : humanPlayer.getExtraZones()) {
            if (extraHand.getZoneType() != ZoneType.ExtraHand) continue;
            this.hands.add(extraHand);
        }
    }

    public PlayerZone getSelectedHand() {
        return this.primaryHand;
    }

    @Override
    protected void showMessage() {
        if (this.hands.isEmpty()) {
            this.stop();
        }
        this.getController().getGui().updateButtons(this.getOwner(), "View Next", "Accept Hand", true, true, true);
        this.showMessage("Select the currently viewed hand to start the game with. The other " + this.hands.size() + " hand(s) will be shuffled into your library.");
    }

    @Override
    protected final void onCancel() {
        this.stop();
    }

    @Override
    protected final void onOk() {
        PlayerZone nextExtraHand = this.hands.poll();
        assert (nextExtraHand != null);
        ArrayList<Card> currentList = Lists.newArrayList(this.primaryHand.getCards().iterator());
        ArrayList<Card> extraList = Lists.newArrayList(nextExtraHand.getCards().iterator());
        this.primaryHand.setCards(extraList);
        nextExtraHand.setCards(currentList);
        this.hands.add(nextExtraHand);
    }

    @Override
    public String getActivateAction(Card card) {
        return null;
    }
}

