/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.phase.PhaseHandler;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityView;
import forge.gamemodes.match.input.Input;
import forge.gui.GuiBase;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.PlayerControllerHuman;
import forge.util.ITriggerEvent;
import forge.util.Localizer;
import java.io.Serializable;
import java.util.List;

public abstract class InputBase
implements Serializable,
Input {
    private static final long serialVersionUID = -2531867688249685076L;
    private final PlayerControllerHuman controller;
    private boolean finished = false;

    public InputBase(PlayerControllerHuman controller0) {
        this.controller = controller0;
    }

    public final PlayerControllerHuman getController() {
        return this.controller;
    }

    @Override
    public PlayerView getOwner() {
        Player owner = this.getController().getPlayer();
        return owner == null ? null : owner.getView();
    }

    protected final boolean isFinished() {
        return this.finished;
    }

    protected final void setFinished() {
        this.finished = true;
        if (this.allowAwaitNextInput()) {
            this.controller.awaitNextInput();
        }
    }

    protected boolean allowAwaitNextInput() {
        return false;
    }

    @Override
    public final void showMessageInitial() {
        this.finished = false;
        this.controller.cancelAwaitNextInput();
        this.showMessage();
    }

    protected abstract void showMessage();

    @Override
    public final void selectPlayer(Player player, ITriggerEvent triggerEvent) {
        if (this.isFinished()) {
            return;
        }
        this.onPlayerSelected(player, triggerEvent);
    }

    @Override
    public boolean selectAbility(SpellAbility ab) {
        return false;
    }

    @Override
    public final void selectButtonCancel() {
        if (this.isFinished()) {
            return;
        }
        this.onCancel();
    }

    @Override
    public final void selectButtonOK() {
        if (this.isFinished()) {
            return;
        }
        this.onOk();
    }

    @Override
    public final boolean selectCard(Card c, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
        if (this.isFinished()) {
            return false;
        }
        return this.onCardSelected(c, otherCardsToSelect, triggerEvent);
    }

    protected boolean onCardSelected(Card c, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
        return false;
    }

    protected void onPlayerSelected(Player player, ITriggerEvent triggerEvent) {
    }

    protected void onCancel() {
    }

    protected void onOk() {
    }

    protected final void showMessage(String message) {
        this.controller.getGui().showPromptMessage(this.getOwner(), message);
    }

    protected final void showMessage(String message, SpellAbilityView sav) {
        if (GuiBase.isNetworkplay()) {
            this.controller.getGui().showPromptMessage(this.getOwner(), message);
        } else {
            this.controller.getGui().showCardPromptMessage(this.getOwner(), message, sav.getHostCard());
        }
    }

    protected final void showMessage(String message, CardView card) {
        if (GuiBase.isNetworkplay()) {
            this.controller.getGui().showPromptMessage(this.getOwner(), message);
        } else {
            this.controller.getGui().showCardPromptMessage(this.getOwner(), message, card);
        }
    }

    protected String getTurnPhasePriorityMessage(Game game) {
        int stormCount;
        PhaseHandler ph = game.getPhaseHandler();
        StringBuilder sb = new StringBuilder();
        Localizer localizer = Localizer.getInstance();
        sb.append(localizer.getMessage("lblPriority", new Object[0])).append(": ").append(ph.getPriorityPlayer()).append("\n");
        sb.append(localizer.getMessage("lblTurn", new Object[0])).append(": ").append(ph.getTurn()).append(" (").append(ph.getPlayerTurn()).append(")");
        if (!game.isNeitherDayNorNight()) {
            sb.append("  [");
            String dayLabel = game.isDay() ? "Day" : "Night";
            sb.append(Localizer.getInstance().getMessage("lbl" + dayLabel, new Object[0]));
            sb.append("]");
        }
        sb.append("\n");
        sb.append(localizer.getMessage("lblPhase", new Object[0])).append(": ").append(ph.getPhase().nameForUi).append("\n");
        sb.append(localizer.getMessage("lblStack", new Object[0])).append(": ");
        if (!game.getStack().isEmpty()) {
            sb.append(game.getStack().size()).append(" ").append(localizer.getMessage("lbltoResolve", new Object[0]));
        } else {
            sb.append(localizer.getMessage("lblEmpty", new Object[0]));
        }
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_SHOW_STORM_COUNT_IN_PROMPT) && (stormCount = game.getView().getStormCount()) > 0) {
            sb.append("\n").append(localizer.getMessage("lblStormCount", new Object[0])).append(": ").append(stormCount);
        }
        if (this.controller.macros() != null) {
            boolean isRecording = this.controller.macros().isRecording();
            String pbText = this.controller.macros().playbackText();
            if (pbText != null) {
                sb.append("\n");
                if (isRecording) {
                    sb.append("Macro Recording -- ");
                } else {
                    sb.append("Macro Playback -- ");
                }
                sb.append(pbText);
            } else if (isRecording) {
                sb.append("\n").append("Macro Recording -- ");
            }
        }
        return sb.toString();
    }
}

