/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match.input;

import com.google.common.collect.Sets;
import forge.game.GameEntity;
import forge.game.GameEntityView;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardView;
import forge.game.combat.AttackingBand;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.event.GameEventCombatUpdate;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerView;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.input.InputSyncronizedBase;
import forge.gui.events.UiEventAttackerDeclared;
import forge.player.PlayerControllerHuman;
import forge.util.ITriggerEvent;
import forge.util.Localizer;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class InputAttack
extends InputSyncronizedBase {
    private static final long serialVersionUID = 7849903731842214245L;
    private final Combat combat;
    private final FCollectionView<GameEntity> defenders;
    private GameEntity currentDefender;
    private final Player playerAttacks;
    private AttackingBand activeBand = null;
    private boolean potentialBanding;

    public InputAttack(PlayerControllerHuman controller, Player attacks0, Combat combat0) {
        super(controller);
        this.playerAttacks = attacks0;
        this.combat = combat0;
        this.defenders = this.combat.getDefenders();
    }

    @Override
    public final void showMessage() {
        this.setCurrentDefender(this.defenders.getFirst());
        if (this.currentDefender == null) {
            System.err.println("InputAttack has no potential defenders!");
            this.updatePrompt();
            return;
        }
        this.updateMessage();
    }

    private boolean canCallBackAttackers() {
        return !this.combat.getAttackers().isEmpty();
    }

    private void updatePrompt() {
        Localizer localizer = Localizer.getInstance();
        String alphaLabel = this.canCallBackAttackers() ? localizer.getMessage("lblCallBack", new Object[0]) : localizer.getMessage("lblAlphaStrike", new Object[0]);
        this.getController().getGui().updateButtons(this.getOwner(), localizer.getMessage("lblOK", new Object[0]), alphaLabel, true, true, true);
    }

    private void disablePrompt() {
        Localizer localizer = Localizer.getInstance();
        this.getController().getGui().updateButtons(this.getOwner(), localizer.getMessage("lblDisabled", new Object[0]), localizer.getMessage("lblDisabled", new Object[0]), false, false, false);
    }

    @Override
    protected final void onOk() {
        this.setCurrentDefender(null);
        this.activateBand(null);
        this.stop();
    }

    @Override
    protected final void onCancel() {
        if (this.canCallBackAttackers()) {
            ArrayList<Card> attackers = new ArrayList<Card>(this.combat.getAttackers());
            for (Card c : attackers) {
                this.undeclareAttacker(c);
            }
        } else {
            this.alphaStrike();
        }
        this.updateMessage();
    }

    void alphaStrike() {
        PlayerCollection defenders = this.playerAttacks.getOpponents();
        HashSet<CardView> refreshCards = Sets.newHashSet();
        block0: for (Card c : this.playerAttacks.getCreaturesInPlay()) {
            if (this.combat.isAttacking(c)) continue;
            if (this.currentDefender != null && CombatUtil.canAttack(c, this.currentDefender)) {
                this.combat.addAttacker(c, this.currentDefender);
                refreshCards.add(CardView.get(c));
                continue;
            }
            for (Player defender : defenders) {
                if (!CombatUtil.canAttack(c, defender)) continue;
                this.combat.addAttacker(c, defender);
                refreshCards.add(CardView.get(c));
                continue block0;
            }
        }
        this.getController().getGui().updateCards(refreshCards);
        this.updateMessage();
    }

    @Override
    protected final void onPlayerSelected(Player selected, ITriggerEvent triggerEvent) {
        if (this.defenders.contains(selected)) {
            this.setCurrentDefender(selected);
        } else {
            this.getController().getGui().flashIncorrectAction();
        }
    }

    @Override
    protected final boolean onCardSelected(Card card, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
        this.disablePrompt();
        CardCollection att = this.combat.getAttackers();
        if (triggerEvent != null && triggerEvent.getButton() == 3 && att.contains(card)) {
            this.undeclareAttacker(card);
            if (otherCardsToSelect != null) {
                for (Card c : otherCardsToSelect) {
                    this.undeclareAttacker(c);
                }
            }
            this.updateMessage();
            return true;
        }
        if (this.combat.isAttacking(card, this.currentDefender)) {
            boolean validAction = true;
            if (this.potentialBanding) {
                if (this.activeBand == null) {
                    this.activateBand(this.combat.getBandOfAttacker(card));
                } else if (this.activeBand.getAttackers().contains(card)) {
                    this.activateBand(null);
                } else if (this.activeBand.canJoinBand(card)) {
                    this.declareAttacker(card);
                    if (otherCardsToSelect != null) {
                        for (Card c : otherCardsToSelect) {
                            if (!this.activeBand.canJoinBand(c)) continue;
                            this.declareAttacker(c);
                        }
                    }
                } else {
                    validAction = false;
                }
            } else {
                this.undeclareAttacker(card);
                if (otherCardsToSelect != null) {
                    for (Card c : otherCardsToSelect) {
                        this.undeclareAttacker(c);
                    }
                }
            }
            this.updateMessage();
            return validAction;
        }
        if ((card.getController().isOpponentOf(this.playerAttacks) || this.playerAttacks.isOpponentOf(card.getProtectingPlayer())) && this.defenders.contains(card)) {
            this.setCurrentDefender(card);
            this.updateMessage();
            return true;
        }
        if (this.playerAttacks.getZone(ZoneType.Battlefield).contains(card) && CombatUtil.canAttack(card, this.currentDefender)) {
            if (this.activeBand != null && !this.activeBand.canJoinBand(card)) {
                this.activateBand(null);
                this.updateMessage();
                return false;
            }
            this.declareAttacker(card);
            if (otherCardsToSelect != null) {
                for (Card c : otherCardsToSelect) {
                    if (!CombatUtil.canAttack(c, this.currentDefender)) continue;
                    this.declareAttacker(c);
                }
            }
            this.updateMessage();
            return true;
        }
        this.updatePrompt();
        return false;
    }

    @Override
    public String getActivateAction(Card card) {
        if (this.combat.isAttacking(card, this.currentDefender)) {
            if (this.potentialBanding) {
                return "activate band with card";
            }
            return "remove card from combat";
        }
        if (card.getController().isOpponentOf(this.playerAttacks)) {
            if (this.defenders.contains(card)) {
                return "declare attackers for card";
            }
            return null;
        }
        if (this.playerAttacks.getZone(ZoneType.Battlefield).contains(card) && CombatUtil.canAttack(card, this.currentDefender)) {
            return "attack with card";
        }
        return null;
    }

    private void declareAttacker(Card card) {
        this.combat.removeFromCombat(card);
        this.combat.addAttacker(card, this.currentDefender, this.activeBand);
        this.activateBand(this.activeBand);
        card.getGame().getMatch().fireEvent(new UiEventAttackerDeclared(CardView.get(card), GameEntityView.get(this.currentDefender)));
    }

    private boolean undeclareAttacker(Card card) {
        this.combat.removeFromCombat(card);
        this.getController().getGui().setUsedToPay(CardView.get(card), false);
        this.activateBand(null);
        card.getGame().getMatch().fireEvent(new UiEventAttackerDeclared(CardView.get(card), null));
        return true;
    }

    private void setCurrentDefender(GameEntity def) {
        this.currentDefender = def;
        for (GameEntity ge : this.defenders) {
            if (ge instanceof Card) {
                this.getController().getGui().setUsedToPay(CardView.get((Card)ge), ge == def);
                continue;
            }
            if (!(ge instanceof Player)) continue;
            this.getController().getGui().setHighlighted(PlayerView.get((Player)ge), ge == def);
        }
        if (def != null) {
            this.potentialBanding = this.isBandingPossible();
        }
        this.updateMessage();
    }

    private void activateBand(AttackingBand band) {
        if (this.activeBand != null) {
            for (Card card : this.activeBand.getAttackers()) {
                this.getController().getGui().setUsedToPay(CardView.get(card), false);
            }
        }
        this.activeBand = band;
        if (this.activeBand != null) {
            for (Card card : this.activeBand.getAttackers()) {
                this.getController().getGui().setUsedToPay(CardView.get(card), true);
            }
        }
    }

    private boolean isBandingPossible() {
        CardCollectionView possibleAttackers = this.playerAttacks.getCardsIn(ZoneType.Battlefield);
        for (Card c : possibleAttackers) {
            if (!c.hasKeyword(Keyword.BANDING) && !c.hasStartOfKeyword("Bands with Other") || !CombatUtil.canAttack(c, this.currentDefender)) continue;
            return true;
        }
        return false;
    }

    private void updateMessage() {
        Localizer localizer = Localizer.getInstance();
        String message = localizer.getMessage("lblSelectAttackCreatures", new Object[0]) + " " + this.currentDefender + " " + localizer.getMessage("lblSelectAttackTarget", new Object[0]);
        if (this.potentialBanding) {
            message = message + localizer.getMessage("lblSelectBandingTarget", new Object[0]);
        }
        this.showMessage(message);
        this.updatePrompt();
        if (this.combat != null) {
            this.getController().getGame().fireEvent(new GameEventCombatUpdate(this.combat.getAttackers(), this.combat.getAllBlockers()));
        }
        this.getController().getGui().showCombat();
    }
}

