/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.match;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import forge.LobbyPlayer;
import forge.ai.AIOption;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckSection;
import forge.game.GameType;
import forge.game.GameView;
import forge.game.IHasGameType;
import forge.game.player.Player;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.match.HostedMatch;
import forge.gamemodes.match.LobbySlot;
import forge.gamemodes.match.LobbySlotType;
import forge.gamemodes.net.event.UpdateLobbyPlayerEvent;
import forge.gui.GuiBase;
import forge.gui.interfaces.IGuiGame;
import forge.gui.util.SOptionPane;
import forge.interfaces.IGameController;
import forge.interfaces.IUpdateable;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.util.Localizer;
import forge.util.NameGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class GameLobby
implements IHasGameType {
    private static final int MAX_PLAYERS = 8;
    private GameLobbyData data = new GameLobbyData();
    private GameType currentGameType = GameType.Constructed;
    private int lastArchenemy = 0;
    private IUpdateable listener;
    private final boolean allowNetworking;
    private HostedMatch hostedMatch;
    private final HashMap<LobbySlot, IGameController> gameControllers = Maps.newHashMap();

    protected GameLobby(boolean allowNetworking) {
        this.allowNetworking = allowNetworking;
    }

    public final boolean isAllowNetworking() {
        return this.allowNetworking;
    }

    public final boolean isMatchActive() {
        return this.hostedMatch != null && !this.hostedMatch.isMatchOver();
    }

    public void setListener(IUpdateable listener) {
        this.listener = listener;
    }

    public GameLobbyData getData() {
        return this.data;
    }

    public void setData(GameLobbyData data) {
        this.data = data;
        this.updateView(true);
    }

    @Override
    public GameType getGameType() {
        return this.currentGameType;
    }

    public void setGameType(GameType type) {
        this.currentGameType = type;
    }

    public boolean hasAnyVariant() {
        return !this.data.appliedVariants.isEmpty();
    }

    public boolean hasVariant(GameType variant) {
        return this.data.appliedVariants.contains((Object)variant);
    }

    public int getNumberOfSlots() {
        return this.data.slots.size();
    }

    public LobbySlot getSlot(int index) {
        if (index < 0 || index >= this.getNumberOfSlots()) {
            return null;
        }
        return (LobbySlot)this.data.slots.get(index);
    }

    public void applyToSlot(int index, UpdateLobbyPlayerEvent event) {
        boolean changed;
        LobbySlot slot = this.getSlot(index);
        if (slot == null || event == null) {
            throw new NullPointerException();
        }
        int nSlots = this.getNumberOfSlots();
        boolean triesToChangeArchenemy = event.getArchenemy() != null;
        boolean archenemyRemoved = triesToChangeArchenemy && event.getArchenemy() == false;
        boolean hasArchenemyChanged = triesToChangeArchenemy && slot.isArchenemy() != event.getArchenemy().booleanValue();
        boolean bl = changed = slot.apply(event) || hasArchenemyChanged;
        if (this.hasVariant(GameType.Archenemy) && hasArchenemyChanged) {
            int newArchenemy;
            int n = newArchenemy = archenemyRemoved ? this.lastArchenemy : index;
            if (archenemyRemoved) {
                this.lastArchenemy = index;
            }
            for (int otherIndex = 0; otherIndex < nSlots; ++otherIndex) {
                boolean becomesArchenemy;
                LobbySlot otherSlot = this.getSlot(otherIndex);
                boolean bl2 = becomesArchenemy = otherIndex == newArchenemy;
                if (!archenemyRemoved && otherSlot.isArchenemy() && !becomesArchenemy) {
                    this.lastArchenemy = otherIndex;
                }
                otherSlot.setIsArchenemy(becomesArchenemy);
            }
        }
        if (event.getType() != null) {
            this.listener.update(index, event.getType());
        }
        if (changed) {
            this.updateView(false);
        }
    }

    public IGameController getController(int index) {
        return this.gameControllers.get(this.getSlot(index));
    }

    public GameView getGameView() {
        return this.hostedMatch.getGameView();
    }

    public abstract boolean hasControl();

    public abstract boolean mayEdit(int var1);

    public abstract boolean mayControl(int var1);

    public abstract boolean mayRemove(int var1);

    protected abstract IGuiGame getGui(int var1);

    protected abstract void onGameStarted();

    public void addSlot() {
        int newIndex = this.getNumberOfSlots();
        LobbySlotType type = this.allowNetworking ? LobbySlotType.OPEN : LobbySlotType.AI;
        this.addSlot(new LobbySlot(type, null, newIndex, newIndex, newIndex, false, !this.allowNetworking, Collections.emptySet()));
    }

    protected final void addSlot(LobbySlot slot) {
        if (slot == null) {
            throw new NullPointerException();
        }
        if (this.data.slots.size() >= 8) {
            return;
        }
        this.data.slots.add(slot);
        if (StringUtils.isEmpty(slot.getName()) && slot.getType() != LobbySlotType.OPEN) {
            slot.setName(this.randomName());
        }
        if (this.data.slots.size() == 1) {
            slot.setIsArchenemy(true);
            this.lastArchenemy = 0;
        }
        this.updateView(true);
    }

    private String randomName() {
        ArrayList<String> names = Lists.newArrayListWithCapacity(8);
        for (LobbySlot slot : this.data.slots) {
            names.add(slot.getName());
        }
        return NameGenerator.getRandomName("Any", "Any", names);
    }

    protected static final String localName() {
        return FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME);
    }

    protected static final int[] localAvatarIndices() {
        String[] sAvatars = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",");
        int[] result = new int[sAvatars.length];
        for (int i = 0; i < sAvatars.length; ++i) {
            Integer val = Ints.tryParse(sAvatars[i]);
            result[i] = val == null ? -1 : val;
        }
        return result;
    }

    protected static final int[] localSleeveIndices() {
        String[] sSleeves = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_SLEEVES).split(",");
        int[] result = new int[sSleeves.length];
        for (int i = 0; i < sSleeves.length; ++i) {
            Integer val = Ints.tryParse(sSleeves[i]);
            result[i] = val == null ? -1 : val;
        }
        return result;
    }

    public void removeSlot(int index) {
        if (index < 0 || index >= this.data.slots.size()) {
            return;
        }
        if (this.getSlot(index).isArchenemy()) {
            this.getSlot(this.lastArchenemy).setIsArchenemy(true);
            this.lastArchenemy = 0;
        } else {
            this.lastArchenemy = this.lastArchenemy == index ? 0 : --this.lastArchenemy;
        }
        this.data.slots.remove(index);
        this.updateView(false);
    }

    public void applyVariant(GameType variant) {
        this.setGameType(variant);
        this.data.appliedVariants.add(variant);
        switch (variant) {
            case Archenemy: {
                this.data.appliedVariants.remove((Object)GameType.ArchenemyRumble);
                break;
            }
            case ArchenemyRumble: {
                this.data.appliedVariants.remove((Object)GameType.Archenemy);
                break;
            }
            case Commander: {
                this.data.appliedVariants.remove((Object)GameType.Oathbreaker);
                this.data.appliedVariants.remove((Object)GameType.TinyLeaders);
                this.data.appliedVariants.remove((Object)GameType.Brawl);
                this.data.appliedVariants.remove((Object)GameType.MomirBasic);
                this.data.appliedVariants.remove((Object)GameType.MoJhoSto);
                break;
            }
            case Oathbreaker: {
                this.data.appliedVariants.remove((Object)GameType.Commander);
                this.data.appliedVariants.remove((Object)GameType.TinyLeaders);
                this.data.appliedVariants.remove((Object)GameType.Brawl);
                this.data.appliedVariants.remove((Object)GameType.MomirBasic);
                this.data.appliedVariants.remove((Object)GameType.MoJhoSto);
                break;
            }
            case TinyLeaders: {
                this.data.appliedVariants.remove((Object)GameType.Commander);
                this.data.appliedVariants.remove((Object)GameType.Oathbreaker);
                this.data.appliedVariants.remove((Object)GameType.Brawl);
                this.data.appliedVariants.remove((Object)GameType.MomirBasic);
                this.data.appliedVariants.remove((Object)GameType.MoJhoSto);
                break;
            }
            case Brawl: {
                this.data.appliedVariants.remove((Object)GameType.Commander);
                this.data.appliedVariants.remove((Object)GameType.Oathbreaker);
                this.data.appliedVariants.remove((Object)GameType.TinyLeaders);
                this.data.appliedVariants.remove((Object)GameType.MomirBasic);
                this.data.appliedVariants.remove((Object)GameType.MoJhoSto);
                break;
            }
            case Vanguard: {
                this.data.appliedVariants.remove((Object)GameType.MomirBasic);
                this.data.appliedVariants.remove((Object)GameType.MoJhoSto);
                break;
            }
            case MomirBasic: {
                this.data.appliedVariants.remove((Object)GameType.Commander);
                this.data.appliedVariants.remove((Object)GameType.Oathbreaker);
                this.data.appliedVariants.remove((Object)GameType.TinyLeaders);
                this.data.appliedVariants.remove((Object)GameType.Brawl);
                this.data.appliedVariants.remove((Object)GameType.Vanguard);
                this.data.appliedVariants.remove((Object)GameType.MoJhoSto);
                break;
            }
            case MoJhoSto: {
                this.data.appliedVariants.remove((Object)GameType.Commander);
                this.data.appliedVariants.remove((Object)GameType.Oathbreaker);
                this.data.appliedVariants.remove((Object)GameType.TinyLeaders);
                this.data.appliedVariants.remove((Object)GameType.Brawl);
                this.data.appliedVariants.remove((Object)GameType.Vanguard);
                this.data.appliedVariants.remove((Object)GameType.MomirBasic);
                break;
            }
        }
        this.updateView(true);
    }

    public void removeVariant(GameType variant) {
        boolean changed = this.data.appliedVariants.remove((Object)variant);
        if (!changed) {
            return;
        }
        if (variant == this.currentGameType) {
            this.currentGameType = this.hasVariant(GameType.Commander) ? GameType.Commander : (this.hasVariant(GameType.Oathbreaker) ? GameType.Oathbreaker : (this.hasVariant(GameType.TinyLeaders) ? GameType.TinyLeaders : (this.hasVariant(GameType.Brawl) ? GameType.Brawl : GameType.Constructed)));
        }
        this.updateView(true);
    }

    public void clearVariants() {
        this.data.appliedVariants.clear();
    }

    public Iterable<GameType> getAppliedVariants() {
        return this.data.appliedVariants;
    }

    private boolean isEnoughTeams() {
        int lastTeam = -1;
        boolean useArchenemyTeams = this.data.appliedVariants.contains((Object)GameType.Archenemy);
        for (LobbySlot slot : this.data.slots) {
            int team;
            int n = useArchenemyTeams ? (slot.isArchenemy() ? 0 : 1) : (team = slot.getTeam());
            if (lastTeam == -1) {
                lastTeam = team;
                continue;
            }
            if (lastTeam == team) continue;
            return true;
        }
        return false;
    }

    protected final void updateView(boolean fullUpdate) {
        if (this.listener != null) {
            this.listener.update(fullUpdate);
        }
    }

    public Runnable startGame() {
        boolean checkLegality;
        ArrayList<LobbySlot> activeSlots = Lists.newArrayListWithCapacity(this.getNumberOfSlots());
        for (LobbySlot slot : this.data.slots) {
            if (slot.getType() == LobbySlotType.OPEN) continue;
            activeSlots.add(slot);
        }
        if (activeSlots.size() < 2) {
            SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblRequiredLeastTwoPlayerStartGame", new Object[0]));
            return null;
        }
        if (!this.isEnoughTeams()) {
            SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblNotEnoughTeams", new Object[0]));
            return null;
        }
        for (LobbySlot slot : activeSlots) {
            if (!slot.isReady()) {
                SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblPlayerIsNotReady", slot.getName()));
                return null;
            }
            if (slot.getDeck() == null) {
                SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblPleaseSpecifyPlayerDeck", slot.getName()));
                return null;
            }
            if (!this.hasVariant(GameType.Commander) && !this.hasVariant(GameType.Oathbreaker) && !this.hasVariant(GameType.TinyLeaders) && !this.hasVariant(GameType.Brawl) || slot.getDeck().has(DeckSection.Commander)) continue;
            SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblPlayerDoesntHaveCommander", slot.getName()));
            return null;
        }
        Set variantTypes = this.data.appliedVariants;
        Object autoGenerateVariant = null;
        boolean isCommanderMatch = false;
        boolean isOathbreakerMatch = false;
        boolean isTinyLeadersMatch = false;
        boolean isBrawlMatch = false;
        if (!variantTypes.isEmpty()) {
            isOathbreakerMatch = variantTypes.contains((Object)GameType.Oathbreaker);
            isTinyLeadersMatch = variantTypes.contains((Object)GameType.TinyLeaders);
            isBrawlMatch = variantTypes.contains((Object)GameType.Brawl);
            boolean bl = isCommanderMatch = isBrawlMatch || isTinyLeadersMatch || isOathbreakerMatch || variantTypes.contains((Object)GameType.Commander);
            if (!isCommanderMatch) {
                for (Object variant : variantTypes) {
                    if (!((GameType)((Object)variant)).isAutoGenerated()) continue;
                    autoGenerateVariant = variant;
                    break;
                }
            }
        }
        if ((checkLegality = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)) && autoGenerateVariant == null && !isCommanderMatch) {
            for (LobbySlot slot : activeSlots) {
                String name = slot.getName();
                String errMsg = GameType.Constructed.getDeckFormat().getDeckConformanceProblem(slot.getDeck());
                if (null == errMsg) continue;
                SOptionPane.showErrorDialog(Localizer.getInstance().getMessage("lblPlayerDeckError", name, errMsg), Localizer.getInstance().getMessage("lblInvalidDeck", new Object[0]));
                return null;
            }
        }
        ArrayList<RegisteredPlayer> players = new ArrayList<RegisteredPlayer>();
        HashMap<RegisteredPlayer, IGuiGame> guis = Maps.newHashMap();
        HashMap<RegisteredPlayer, LobbySlot> playerToSlot = Maps.newHashMap();
        boolean hasNameBeenSet = false;
        for (LobbySlot slot : activeSlots) {
            LobbyPlayer lobbyPlayer;
            boolean isAI;
            IGuiGame gui = this.getGui(this.data.slots.indexOf(slot));
            String name = slot.getName();
            int avatar = slot.getAvatarIndex();
            int sleeve = slot.getSleeveIndex();
            boolean isArchenemy = slot.isArchenemy();
            int team = GameType.Archenemy.equals((Object)this.currentGameType) && !isArchenemy ? 1 : slot.getTeam();
            ImmutableSet<AIOption> aiOptions = slot.getAiOptions();
            boolean bl = isAI = slot.getType() == LobbySlotType.AI;
            if (isAI) {
                lobbyPlayer = GamePlayerUtil.createAiPlayer(name, avatar, sleeve, aiOptions);
            } else {
                boolean setNameNow = false;
                if (!hasNameBeenSet && slot.getType() == LobbySlotType.LOCAL) {
                    setNameNow = true;
                    hasNameBeenSet = true;
                }
                lobbyPlayer = GamePlayerUtil.getGuiPlayer(name, avatar, sleeve, setNameNow);
            }
            Deck deck = slot.getDeck();
            RegisteredPlayer rp = new RegisteredPlayer(deck);
            if (variantTypes.isEmpty()) {
                rp.setTeamNumber(team);
                players.add(rp.setPlayer(lobbyPlayer));
            } else {
                String errMsg;
                DeckSection[] errMsg2;
                if (isCommanderMatch) {
                    GameType commanderGameType;
                    GameType gameType = isOathbreakerMatch ? GameType.Oathbreaker : (isTinyLeadersMatch ? GameType.TinyLeaders : (commanderGameType = isBrawlMatch ? GameType.Brawl : GameType.Commander));
                    if (checkLegality && (errMsg2 = commanderGameType.getDeckFormat().getDeckConformanceProblem(deck)) != null) {
                        SOptionPane.showErrorDialog(Localizer.getInstance().getMessage("lblPlayerDeckError", new Object[]{name, errMsg2}), Localizer.getInstance().getMessage("lblInvalidCommanderGameTypeDeck", new Object[]{commanderGameType}));
                        return null;
                    }
                } else if (autoGenerateVariant != null) {
                    Deck autoDeck = ((GameType)((Object)autoGenerateVariant)).autoGenerateDeck(rp);
                    deck = new Deck();
                    errMsg2 = DeckSection.values();
                    int n = errMsg2.length;
                    for (int i = 0; i < n; ++i) {
                        DeckSection d = errMsg2[i];
                        if (!autoDeck.has(d)) continue;
                        deck.getOrCreate(d).clear();
                        deck.get(d).addAll(autoDeck.get(d));
                    }
                }
                deck = deck == null ? rp.getDeck() : deck;
                CardPool avatarPool = deck.get(DeckSection.Avatar);
                List<PaperCard> schemes = null;
                List<PaperCard> planes = null;
                if (variantTypes.contains((Object)GameType.ArchenemyRumble) || variantTypes.contains((Object)GameType.Archenemy) && isArchenemy) {
                    CardPool schemePool = deck.get(DeckSection.Schemes);
                    if (checkLegality && null != (errMsg = DeckFormat.getSchemeSectionConformanceProblem(schemePool))) {
                        SOptionPane.showErrorDialog(Localizer.getInstance().getMessage("lblPlayerDeckError", name, errMsg), Localizer.getInstance().getMessage("lblInvalidSchemeDeck", new Object[0]));
                        return null;
                    }
                    List<PaperCard> list = schemes = schemePool == null ? Collections.emptyList() : schemePool.toFlatList();
                }
                if (variantTypes.contains((Object)GameType.Planechase)) {
                    CardPool planePool = deck.get(DeckSection.Planes);
                    if (checkLegality && null != (errMsg = DeckFormat.getPlaneSectionConformanceProblem(planePool))) {
                        SOptionPane.showErrorDialog(Localizer.getInstance().getMessage("lblPlayerDeckError", name, errMsg), Localizer.getInstance().getMessage("lblInvalidPlanarDeck", new Object[0]));
                        return null;
                    }
                    List<PaperCard> list = planes = planePool == null ? Collections.emptyList() : planePool.toFlatList();
                }
                if (variantTypes.contains((Object)GameType.Vanguard) && (avatarPool == null || avatarPool.countAll() == 0)) {
                    SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblNoSelectedVanguardAvatarForPlayer", name));
                    return null;
                }
                rp = RegisteredPlayer.forVariants(activeSlots.size(), variantTypes, deck, schemes, isArchenemy, planes, avatarPool);
                rp.setTeamNumber(team);
                players.add(rp.setPlayer(lobbyPlayer));
            }
            if (!isAI) {
                guis.put(rp, gui);
            }
            if (this.hasVariant(GameType.Brawl) && activeSlots.size() == 2) {
                for (RegisteredPlayer player : players) {
                    player.setStartingLife(25);
                }
            }
            playerToSlot.put(rp, slot);
        }
        return () -> {
            this.hostedMatch = GuiBase.getInterface().hostMatch();
            this.hostedMatch.startMatch(GameType.Constructed, variantTypes, players, guis);
            for (Player p : this.hostedMatch.getGame().getPlayers()) {
                LobbySlot slot = (LobbySlot)playerToSlot.get(p.getRegisteredPlayer());
                if (!(p.getController() instanceof IGameController)) continue;
                this.gameControllers.put(slot, (IGameController)((Object)p.getController()));
            }
            this.hostedMatch.gameControllers = this.gameControllers;
            this.onGameStarted();
        };
    }

    public static final class GameLobbyData
    implements Serializable {
        private static final long serialVersionUID = 9184758307999646864L;
        private final Set<GameType> appliedVariants = EnumSet.noneOf(GameType.class);
        private final List<LobbySlot> slots = Lists.newArrayList();
    }
}

