/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import forge.deck.CardPool;
import forge.gamemodes.limited.BoosterDraftAI;
import forge.gamemodes.limited.DeckColors;
import forge.gamemodes.limited.WinstonDraft;
import forge.util.ItemPool;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.List;

public class WinstonDraftAI
extends BoosterDraftAI {
    private WinstonDraft draft = null;
    private static final int N_DECKS = 1;
    private List<Byte> colorPreference = new ArrayList<Byte>();

    public WinstonDraft getDraft() {
        return this.draft;
    }

    public void setDraft(WinstonDraft draft) {
        this.draft = draft;
    }

    public WinstonDraftAI() {
        this.decks.clear();
        this.playerColors.clear();
        for (int i = 0; i < 1; ++i) {
            this.decks.add(new ArrayList());
            this.playerColors.add(new DeckColors());
        }
    }

    public void determineDeckColor() {
        ((DeckColors)this.playerColors.get(0)).setColorsByList(this.colorPreference.subList(0, 3));
    }

    public void choose() {
        boolean takenPile = true;
        ItemPool acquire = null;
        while (takenPile) {
            boolean takePile;
            CardPool pool = this.draft.getActivePool();
            String desc = "Pile " + (this.draft.getCurrentBoosterIndex() + 1);
            int value = pool.countAll() * 10;
            boolean bl = takePile = MyRandom.percentTrue(value) || this.draft.isLastPileAndEmptyDeck(this.draft.getCurrentBoosterIndex());
            if (takePile) {
                acquire = this.draft.takeActivePile(false);
            } else {
                acquire = this.draft.passActivePile(false);
                desc = "Top of Deck";
            }
            if (acquire == null) continue;
            System.out.println("AI taking " + desc + "(" + acquire.countAll() + " cards).");
            takenPile = false;
        }
        if (acquire != null) {
            ((List)this.decks.get(0)).addAll(acquire.toFlatList());
        }
    }

    public int getAIDraftSize() {
        return ((List)this.decks.get(0)).size();
    }
}

