/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.limited.LimitedPoolType;
import forge.gamemodes.limited.WinstonDraftAI;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class WinstonDraft
extends BoosterDraft {
    private WinstonDraftAI draftAI = null;
    private static int NUM_PILES = 3;
    private static int NUM_PLAYERS = 2;
    private Stack<PaperCard> deck;
    private List<List<PaperCard>> piles;

    public static WinstonDraft createDraft(LimitedPoolType draftType) {
        WinstonDraft draft = new WinstonDraft(draftType);
        if (!draft.generateProduct()) {
            return null;
        }
        draft.initializeWinstonDraft();
        return draft;
    }

    private WinstonDraft(LimitedPoolType draftType) {
        this.draftFormat = draftType;
        this.draftAI = new WinstonDraftAI();
    }

    private void initializeWinstonDraft() {
        this.deck = new Stack();
        for (Supplier supply : this.product) {
            for (int j = 0; j < NUM_PLAYERS; ++j) {
                for (PaperCard paperCard : Iterables.filter((Iterable)supply.get(), Predicates.not(IPaperCard.Predicates.Presets.IS_BASIC_LAND))) {
                    this.deck.add(paperCard);
                }
            }
        }
        Collections.shuffle(this.deck, MyRandom.getRandom());
        this.piles = new ArrayList<List<PaperCard>>();
        for (int i = 0; i < NUM_PILES; ++i) {
            ArrayList<PaperCard> pile = new ArrayList<PaperCard>();
            pile.add(this.deck.pop());
            this.piles.add(pile);
        }
        this.nextBoosterGroup = 0;
        this.draftAI.setDraft(this);
        if (MyRandom.percentTrue(50)) {
            // empty if block
        }
    }

    @Override
    public CardPool nextChoice() {
        int nextPile = -1;
        for (int i = this.nextBoosterGroup; i < this.piles.size(); ++i) {
            if (this.piles.get(i).size() <= 0) continue;
            nextPile = i;
            break;
        }
        if (nextPile < 0 || nextPile > this.piles.size()) {
            return null;
        }
        this.nextBoosterGroup = nextPile;
        return this.getPoolByPile(this.nextBoosterGroup);
    }

    public CardPool getActivePool() {
        return this.getPoolByPile(this.nextBoosterGroup);
    }

    private CardPool getPoolByPile(int i) {
        CardPool result = new CardPool();
        result.addAllFlat((Iterable)this.piles.get(i));
        return result;
    }

    @Override
    public void computerChoose() {
        this.nextBoosterGroup = 0;
        this.draftAI.choose();
    }

    public void refillPile(List<PaperCard> pile) {
        if (this.deck.size() > 0) {
            pile.add(this.deck.pop());
        }
    }

    public int getNextChoice(int startPile) {
        for (int i = startPile; i < NUM_PILES; ++i) {
            if (this.piles.get(i).size() <= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean hasNextChoice() {
        return this.getNextChoice(0) >= 0;
    }

    @Override
    public boolean isRoundOver() {
        return this.hasNextChoice();
    }

    public boolean isLastPileAndEmptyDeck(int pile) {
        return this.deck.size() == 0 && this.getNextChoice(pile + 1) >= 0;
    }

    @Override
    public int getCurrentBoosterIndex() {
        return this.nextBoosterGroup;
    }

    public CardPool takeActivePile(boolean humanAction) {
        CardPool pool = this.getPoolByPile(this.nextBoosterGroup);
        this.piles.get(this.nextBoosterGroup).clear();
        this.refillPile(this.piles.get(this.nextBoosterGroup));
        this.nextBoosterGroup = 0;
        if (humanAction) {
            this.computerChoose();
        }
        return pool;
    }

    public CardPool passActivePile(boolean humanAction) {
        this.refillPile(this.piles.get(this.nextBoosterGroup));
        ++this.nextBoosterGroup;
        if (this.nextBoosterGroup >= this.piles.size()) {
            CardPool pool = new CardPool();
            if (this.deck.size() > 0) {
                pool.add(this.deck.pop());
            }
            this.nextBoosterGroup = 0;
            if (humanAction) {
                this.computerChoose();
            }
            return pool;
        }
        return null;
    }

    public int getNumPiles() {
        return NUM_PILES;
    }

    @Override
    public Deck[] getDecks() {
        this.determineAIDeckColors();
        return this.draftAI.getDecks();
    }

    public void determineAIDeckColors() {
        this.draftAI.determineDeckColor();
    }

    @Override
    public boolean isPileDraft() {
        return true;
    }

    public int getDeckSize() {
        return this.deck.size();
    }

    public int getAIDraftSize() {
        return this.draftAI.getAIDraftSize();
    }
}

