/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.card.CardEdition;
import forge.card.MagicColor;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.gamemodes.limited.DraftPack;
import forge.gamemodes.limited.IBoosterDraft;
import forge.gamemodes.limited.LimitedPlayerAI;
import forge.gui.util.SGuiChoose;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;

public class LimitedPlayer {
    protected final int order;
    protected int currentPack;
    protected int draftedThisRound;
    protected Deck deck;
    protected PaperCard lastPick;
    protected Queue<DraftPack> packQueue;
    protected Queue<DraftPack> unopenedPacks;
    protected List<PaperCard> removedFromCardPool = new ArrayList<PaperCard>();
    protected List<Integer> archdemonFavors;
    protected int dealBrokers = 0;
    private static final int AgentAcquisitionsCanDraftAll = 1;
    private static final int AgentAcquisitionsIsDraftingAll = 2;
    private static final int AgentAcquisitionsSkipDraftRound = 4;
    private static final int CogworkLibrarianExtraDraft = 8;
    private static final int CogworkLibrarianReturnLibrarian = 16;
    private static final int AnimusRemoveFromPool = 32;
    private static final int NobleBanneretActive = 64;
    private static final int PalianoVanguardActive = 128;
    private static final int GrinderRemoveFromPool = 256;
    private static final int SearcherNoteNext = 512;
    private static final int WhispergearBoosterPeek = 1024;
    private static final int IllusionaryInformantPeek = 2048;
    private static final int LeovoldsOperativeCanExtraDraft = 4096;
    private static final int LeovoldsOperativeExtraDraft = 8192;
    private static final int LeovoldsOperativeSkipNext = 16384;
    private static final int SpyNextCardDrafted = 32768;
    private static final int CanalDredgerLastPick = 65536;
    private static final int ArchdemonOfPalianoCurse = 131072;
    private static final int SmugglerCaptainActive = 262144;
    private int playerFlags = 0;
    private final List<PaperCard> faceUp = Lists.newArrayList();
    private final List<PaperCard> revealed = Lists.newArrayList();
    private final Map<String, List<String>> noted = new HashMap<String, List<String>>();
    private final HashSet<String> semicolonDelimiter = Sets.newHashSet("Noble Banneret", "Cogwork Grinder", "Aether Searcher", "Smuggler Captain");
    IBoosterDraft draft;

    public LimitedPlayer(int seatingOrder, IBoosterDraft draft) {
        this.order = seatingOrder;
        this.deck = new Deck();
        this.packQueue = new LinkedList<DraftPack>();
        this.unopenedPacks = new LinkedList<DraftPack>();
        this.archdemonFavors = new ArrayList<Integer>();
        this.draft = draft;
    }

    public Map<String, List<String>> getDraftNotes() {
        return this.noted;
    }

    public Map<String, String> getSerializedDraftNotes() {
        HashMap<String, String> serialized = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : this.noted.entrySet()) {
            serialized.put(entry.getKey(), TextUtil.join((Iterable<String>)entry.getValue(), this.semicolonDelimiter.contains(entry.getKey()) ? ";" : ","));
        }
        return serialized;
    }

    public PaperCard getLastPick() {
        return this.lastPick;
    }

    public Deck getDeck() {
        return this.deck;
    }

    public List<PaperCard> getRemovedFromCardPool() {
        return this.removedFromCardPool;
    }

    public PaperCard chooseCard() {
        return null;
    }

    public Boolean draftCard(PaperCard bestPick) {
        return this.draftCard(bestPick, DeckSection.Sideboard);
    }

    public Boolean draftCard(PaperCard bestPick, DeckSection section) {
        List note;
        LimitedPlayer fromPlayer;
        if (bestPick == null) {
            return null;
        }
        DraftPack chooseFrom = this.packQueue.peek();
        if (chooseFrom == null) {
            return null;
        }
        boolean removedFromPool = false;
        boolean alreadyRevealed = false;
        boolean passPack = true;
        chooseFrom.remove(bestPick);
        this.lastPick = bestPick;
        ++this.draftedThisRound;
        ArrayList<String> removeFromSource = Lists.newArrayList();
        String choice = null;
        if ((this.playerFlags & 0x20) == 32) {
            removeFromSource.add("Animus of Predation");
        }
        if ((this.playerFlags & 0x100) == 256) {
            removeFromSource.add("Cogwork Grinder");
        }
        if (!removeFromSource.isEmpty()) {
            removeFromSource.add(0, "Don't Remove");
            choice = this.removeWithAny(bestPick, removeFromSource);
        }
        if (choice != null && !choice.equals("Don't Remove")) {
            removedFromPool = true;
            this.removedFromCardPool.add(bestPick);
            if (choice.equals("Animus of Predation")) {
                this.addLog(this.name() + " removed " + bestPick.getName() + " from the draft with " + choice + ".");
            } else if (choice.equals("Cogwork Grinder")) {
                this.addLog(this.name() + " removed a card face down from the draft with " + choice + ".");
            }
            this.recordRemoveFromDraft(bestPick, choice);
        }
        if ((fromPlayer = chooseFrom.getPassedFrom()) != null && (fromPlayer.playerFlags & 0x8000) == 32768) {
            if (fromPlayer instanceof LimitedPlayerAI) {
                this.addLog(this.name() + " revealed a card to " + fromPlayer.name() + " via Cogwork Spy.");
            } else {
                this.addLog(this.name() + " revealed " + bestPick.getName() + " to you with Cogwork Spy.");
            }
            fromPlayer.playerFlags &= 0xFFFF7FFF;
        }
        if ((this.playerFlags & 0x200) == 512) {
            this.addLog(this.name() + " revealed " + bestPick.getName() + " for Aether Searcher.");
            this.playerFlags &= 0xFFFFFDFF;
            note = this.noted.computeIfAbsent("Aether Searcher", k -> Lists.newArrayList());
            note.add(String.valueOf(bestPick.getName()));
        }
        if ((this.playerFlags & 0x40000) == 262144 && this.revealWithSmuggler(bestPick)) {
            this.addLog(this.name() + " revealed " + bestPick.getName() + " for Smuggler Captain.");
            this.playerFlags &= 0xFFFBFFFF;
            note = this.noted.computeIfAbsent("Smuggler Captain", k -> Lists.newArrayList());
            note.add(String.valueOf(bestPick.getName()));
        }
        if ((this.playerFlags & 0x400) == 1024 && this.handleWhispergearSneak()) {
            this.addLog(this.name() + " peeked at a booster pack with Whispergear Sneak and turned it face down.");
            this.playerFlags &= 0xFFFFFBFF;
        }
        if ((this.playerFlags & 0x800) == 2048 && this.handleIllusionaryInformant()) {
            this.addLog(this.name() + " peeked at " + fromPlayer.name() + "'s next pick with Illusionary Informant and turned it face down.");
            this.playerFlags &= 0xFFFFF7FF;
        }
        if ((this.playerFlags & 1) == 1 && this.handleAgentOfAcquisitions(chooseFrom, bestPick)) {
            this.addLog(this.name() + " drafted the rest of the pack with Agent of Acquisitions");
            this.playerFlags &= 0xFFFFFFFE;
            this.playerFlags |= 2;
        }
        if ((this.playerFlags & 2) == 2) {
            if (chooseFrom.isEmpty()) {
                this.playerFlags &= 0xFFFFFFFD;
                this.playerFlags |= 4;
            } else {
                passPack = false;
            }
        }
        if ((this.playerFlags & 0x2000) == 8192 && this.handleLeovoldsOperative(chooseFrom, bestPick)) {
            this.addLog(this.name() + " skipped their next pick with Leovold's Operative.");
            this.playerFlags &= 0xFFFFDFFF;
            this.playerFlags |= 0x4000;
            passPack = false;
        }
        if ((this.playerFlags & 0x1000) == 4096 && this.handleLeovoldsOperative(chooseFrom, bestPick)) {
            this.addLog(this.name() + " picking again with Leovold's Operative.");
            this.playerFlags &= 0xFFFFEFFF;
            this.playerFlags |= 0x2000;
            passPack = false;
        }
        if ((this.playerFlags & 0x10) == 16) {
            this.addLog(this.name() + " returned Cogwork Librarian to the pack.");
            PaperCard librarian = this.deck.removeCardName("Cogwork Librarian");
            this.playerFlags &= 0xFFFFFFEF;
            if (librarian != null) {
                chooseFrom.add(librarian);
            } else {
                System.out.println("This shouldn't happen. We drafted a libarian but didn't remove it properly.");
            }
        }
        if ((this.playerFlags & 8) == 8 && this.handleCogworkLibrarian(chooseFrom, bestPick)) {
            this.addLog(this.name() + " drafted an extra card with Cogwork Librarian.");
            this.playerFlags &= 0xFFFFFFF7;
            this.playerFlags |= 0x10;
            passPack = false;
        }
        if (chooseFrom.getAwaitingGuess() != null) {
            this.comparePhantasmGuess(chooseFrom, bestPick);
        }
        if (removedFromPool) {
            return passPack;
        }
        CardPool pool = this.deck.getOrCreate(section);
        pool.add(bestPick);
        alreadyRevealed |= this.handleNobleBanneret(bestPick);
        alreadyRevealed |= this.handlePalianoVanguard(bestPick);
        Iterable<String> draftActions = bestPick.getRules().getMainPart().getDraftActions();
        if (draftActions == null || !draftActions.iterator().hasNext()) {
            return passPack;
        }
        if (Iterables.contains(draftActions, "Reveal CARDNAME as you draft it.")) {
            if (!alreadyRevealed) {
                this.revealed.add(bestPick);
                this.showRevealedCard(bestPick);
            }
            if (Iterables.contains(draftActions, "Note how many cards you've drafted this draft round, including CARDNAME.")) {
                List note2 = this.noted.computeIfAbsent(bestPick.getName(), k -> Lists.newArrayList());
                note2.add(String.valueOf(this.draftedThisRound));
                this.addLog(this.name() + " revealed " + bestPick.getName() + " and noted " + this.draftedThisRound + " cards drafted this round.");
            } else if (Iterables.contains(draftActions, "As you draft CARDNAME, the player to your right chooses a color, you choose another color, then the player to your left chooses a third color.")) {
                ArrayList<String> chosenColors = new ArrayList<String>();
                LimitedPlayer leftPlayer = this.draft.getNeighbor(this, true);
                LimitedPlayer rightPlayer = this.draft.getNeighbor(this, false);
                ArrayList<String> availableColors = new ArrayList<String>(MagicColor.Constant.ONLY_COLORS);
                String c = rightPlayer.chooseColor(availableColors, this, bestPick.getName());
                chosenColors.add(c);
                availableColors.remove(c);
                c = this.chooseColor(availableColors, this, bestPick.getName());
                chosenColors.add(c);
                availableColors.remove(c);
                c = leftPlayer.chooseColor(availableColors, this, bestPick.getName());
                chosenColors.add(c);
                availableColors.remove(c);
                List note3 = this.noted.computeIfAbsent(bestPick.getName(), k -> Lists.newArrayList());
                note3.add(String.join((CharSequence)",", chosenColors));
                this.addLog(this.name() + " revealed " + bestPick.getName() + " and noted " + String.join((CharSequence)",", chosenColors) + " chosen colors.");
            } else {
                if (Iterables.contains(draftActions, "You may look at the next card drafted from this booster pack.")) {
                    this.playerFlags |= 0x8000;
                } else if (fromPlayer != null && Iterables.contains(draftActions, "Note the player who passed CARDNAME to you.")) {
                    List note4 = this.noted.computeIfAbsent(bestPick.getName(), k -> Lists.newArrayList());
                    note4.add(String.valueOf(fromPlayer.order));
                    this.addLog(this.name() + " revealed " + bestPick.getName() + " and noted " + fromPlayer.name() + " passed it.");
                } else if (Iterables.contains(draftActions, "Reveal the next card you draft and note its name.")) {
                    this.playerFlags |= 0x200;
                } else if (Iterables.contains(draftActions, "The next time a player drafts a card from this booster pack, guess that card's name. Then that player reveals the drafted card.")) {
                    chooseFrom.setAwaitingGuess(this, this.handleSpirePhantasm(chooseFrom));
                } else if (Iterables.contains(draftActions, "After you draft CARDNAME, you may add a booster pack to the draft. (Your next pick is from that booster pack. Pass it to the next player and it's drafted this draft round.)")) {
                    this.addSingleBoosterPack();
                }
                this.addLog(this.name() + " revealed " + bestPick.getName() + " as " + this.name() + " drafted it.");
            }
        }
        if (Iterables.contains(draftActions, "Draft CARDNAME face up.")) {
            this.faceUp.add(bestPick);
            this.addLog(this.name() + " drafted " + bestPick.getName() + " face up.");
            if (!alreadyRevealed) {
                this.showRevealedCard(bestPick);
            }
            if (Iterables.contains(draftActions, "As you draft a card, you may remove it from the draft face up. (It isn't in your card pool.)") && bestPick.getName().equals("Animus of Predation")) {
                this.playerFlags |= 0x20;
            } else if (Iterables.contains(draftActions, "As you draft a card, you may remove it from the draft face down. (Those cards aren't in your card pool.)") && bestPick.getName().equals("Cogwork Grinder")) {
                this.playerFlags |= 0x100;
            } else if (Iterables.contains(draftActions, "As you draft a creature card, you may reveal it, note its name, then turn CARDNAME face down.")) {
                this.playerFlags |= 0x40;
            } else if (Iterables.contains(draftActions, "As you draft a card, you may reveal it, note its name, then turn CARDNAME face down.")) {
                this.playerFlags |= 0x40000;
            } else if (Iterables.contains(draftActions, "As you draft a creature card, you may reveal it, note its creature types, then turn CARDNAME face down.")) {
                this.playerFlags |= 0x80;
            } else if (Iterables.contains(draftActions, "During the draft, you may turn CARDNAME face down. If you do, look at any unopened booster pack in the draft or any booster pack not being looked at by another player.")) {
                this.playerFlags |= 0x400;
            } else if (Iterables.contains(draftActions, "During the draft, you may turn CARDNAME face down. If you do, look at the next card drafted by a player of your choice.")) {
                this.playerFlags |= 0x800;
            } else if (Iterables.contains(draftActions, "As you draft a card, you may draft an additional card from that booster pack. If you do, put CARDNAME into that booster pack.")) {
                this.playerFlags |= 8;
            } else if (Iterables.contains(draftActions, "As you draft a card, you may draft an additional card from that booster pack. If you do, turn CARDNAME face down, then pass the next booster pack without drafting a card from it. (You may look at that booster pack.)")) {
                this.playerFlags |= 0x2000;
            } else if (Iterables.contains(draftActions, "Instead of drafting a card from a booster pack, you may draft each card in that booster pack, one at a time. If you do, turn CARDNAME face down and you can't draft cards for the rest of this draft round. (You may look at booster packs passed to you.)")) {
                this.playerFlags |= 1;
            } else if (Iterables.contains(draftActions, "Each player passes the last card from each booster pack to a player who drafted a card named CARDNAME.")) {
                this.playerFlags |= 0x10000;
            } else if (Iterables.contains(draftActions, "As long as CARDNAME is face up during the draft, you can't look at booster packs and must draft cards at random. After you draft three cards this way, turn CARDNAME face down. (You may look at cards as you draft them.)")) {
                this.playerFlags |= 0x20000;
                this.archdemonFavors.add(3);
            } else if (Iterables.contains(draftActions, "Immediately after the draft, you may reveal a card in your card pool. Each other player may offer you one card in their card pool in exchange. You may accept any one offer.")) {
                ++this.dealBrokers;
            }
        }
        return true;
    }

    public void addLog(String message) {
        if (this.draft.getDraftLog() != null) {
            this.draft.getDraftLog().addLogEntry(message);
        }
    }

    public DraftPack nextChoice() {
        DraftPack pack = this.packQueue.peek();
        if (pack != null) {
            this.adjustPackNumber(pack);
        }
        return pack;
    }

    public void newPack() {
        this.currentPack = this.order;
        this.draftedThisRound = 0;
        this.packQueue.add(this.unopenedPacks.poll());
        this.playerFlags &= 0xFFFFFFFB;
    }

    public void adjustPackNumber(DraftPack pack) {
        this.currentPack = pack.getId();
    }

    public DraftPack passPack() {
        DraftPack pack = this.packQueue.poll();
        if (pack != null) {
            pack.setPassedFrom(this);
        }
        return pack;
    }

    public boolean shouldSkipThisPick() {
        boolean skipping;
        boolean bl = skipping = (this.playerFlags & 4) == 4 || (this.playerFlags & 0x4000) == 16384;
        if (skipping && (this.playerFlags & 0x4000) == 16384) {
            this.playerFlags &= 0xFFFFBFFF;
        }
        return skipping;
    }

    public boolean hasCanalDredger() {
        return (this.playerFlags & 0x10000) == 65536;
    }

    public void receiveUnopenedPack(DraftPack pack) {
        this.unopenedPacks.add(pack);
    }

    public void receiveOpenedPack(DraftPack pack) {
        this.packQueue.add(pack);
    }

    protected String chooseColor(List<String> colors, LimitedPlayer player, String title) {
        return SGuiChoose.one(player.name() + " drafted " + title + ": Choose a color", colors);
    }

    protected String removeWithAny(PaperCard bestPick, List<String> options) {
        return SGuiChoose.one("Remove this " + bestPick + " from the draft with?", options);
    }

    protected boolean revealWithBanneret(PaperCard bestPick) {
        return SGuiChoose.one("Reveal this " + bestPick + " for Noble Banneret?", Lists.newArrayList("Yes", "No")).equals("Yes");
    }

    protected boolean revealWithVanguard(PaperCard bestPick) {
        return SGuiChoose.one("Reveal this " + bestPick + " for Paliano Vanguard?", Lists.newArrayList("Yes", "No")).equals("Yes");
    }

    protected boolean revealWithSmuggler(PaperCard bestPick) {
        return SGuiChoose.one("Reveal this " + bestPick + " for Smuggler Captain?", Lists.newArrayList("Yes", "No")).equals("Yes");
    }

    public String name() {
        if (this instanceof LimitedPlayerAI) {
            return "Player[" + this.order + "]";
        }
        return "You";
    }

    public void showRevealedCard(PaperCard pick) {
    }

    public void recordRemoveFromDraft(PaperCard bestPick, String host) {
        List note = this.noted.computeIfAbsent(host, k -> Lists.newArrayList());
        if (host.equals("Animus of Predation")) {
            if (!bestPick.getRules().getType().isCreature()) {
                return;
            }
            ArrayList<String> keywords = new ArrayList<String>();
            for (String keyword : bestPick.getRules().getMainPart().getKeywords()) {
                if (keyword.startsWith("Hexproof")) {
                    keywords.add(keyword);
                    continue;
                }
                switch (keyword) {
                    case "Flying": {
                        keywords.add("Flying");
                        break;
                    }
                    case "First Strike": {
                        keywords.add("First Strike");
                        break;
                    }
                    case "Double Strike": {
                        keywords.add("Double Strike");
                        break;
                    }
                    case "Deathtouch": {
                        keywords.add("Deathtouch");
                        break;
                    }
                    case "Haste": {
                        keywords.add("Haste");
                        break;
                    }
                    case "Indestructible": {
                        keywords.add("Indestructible");
                        break;
                    }
                    case "Lifelink": {
                        keywords.add("Lifelink");
                        break;
                    }
                    case "Menace": {
                        keywords.add("Menace");
                        break;
                    }
                    case "Reach": {
                        keywords.add("Reach");
                        break;
                    }
                    case "Vigilance": {
                        keywords.add("Vigilance");
                    }
                }
            }
            note.add(String.join((CharSequence)",", keywords));
        } else if (host.equals("Cogwork Grinder")) {
            note.add(bestPick.getName());
        }
    }

    public boolean handleNobleBanneret(PaperCard bestPick) {
        if ((this.playerFlags & 0x40) != 64) {
            return false;
        }
        if (!bestPick.getRules().getType().isCreature()) {
            return false;
        }
        boolean remaining = false;
        PaperCard found = null;
        for (PaperCard c : this.faceUp) {
            if (!c.getName().equals("Noble Banneret")) continue;
            if (found == null) {
                found = c;
                continue;
            }
            remaining = true;
            break;
        }
        if (found == null) {
            this.playerFlags &= 0xFFFFFFBF;
            return false;
        }
        if (!this.revealWithBanneret(bestPick)) {
            return false;
        }
        List note = this.noted.computeIfAbsent(found.getName(), k -> Lists.newArrayList());
        this.revealed.add(bestPick);
        note.add(bestPick.getName());
        this.addLog(this.name() + " revealed " + bestPick.getName() + " and noted its name for Noble Banneret.");
        this.addLog(this.name() + " has flipped Noble Banneret face down.");
        boolean alreadyRevealed = true;
        this.faceUp.remove(found);
        if (!remaining) {
            this.playerFlags &= 0xFFFFFFBF;
        }
        return alreadyRevealed;
    }

    public boolean handlePalianoVanguard(PaperCard bestPick) {
        if ((this.playerFlags & 0x80) != 128) {
            return false;
        }
        if (!bestPick.getRules().getType().isCreature()) {
            return false;
        }
        boolean remaining = false;
        PaperCard found = null;
        for (PaperCard c : this.faceUp) {
            if (!c.getName().equals("Paliano Vanguard")) continue;
            if (found == null) {
                found = c;
                continue;
            }
            remaining = true;
            break;
        }
        if (found == null) {
            this.playerFlags &= 0xFFFFFF7F;
            return false;
        }
        if (!this.revealWithVanguard(bestPick)) {
            return false;
        }
        List note = this.noted.computeIfAbsent(found.getName(), k -> Lists.newArrayList());
        this.revealed.add(bestPick);
        note.addAll(bestPick.getRules().getType().getCreatureTypes());
        this.addLog(this.name() + " revealed " + bestPick.getName() + " and noted - " + TextUtil.join(bestPick.getRules().getType().getCreatureTypes(), ",") + " for Paliano Vanguard.");
        this.addLog(this.name() + " has flipped Paliano Vanguard face down.");
        boolean alreadyRevealed = true;
        this.faceUp.remove(found);
        if (!remaining) {
            this.playerFlags &= 0xFFFFFF7F;
        }
        return alreadyRevealed;
    }

    public boolean handleWhispergearSneak() {
        if (Objects.equals(SGuiChoose.oneOrNone("Peek at a booster pack with Whispergear Sneak?", Lists.newArrayList("Yes", "No")), "No")) {
            return false;
        }
        int round = 3;
        if (this.draft.getRound() != 3) {
            round = SGuiChoose.getInteger("Which round would you like to peek at?", this.draft.getRound(), 3);
        }
        int playerId = SGuiChoose.getInteger("Which player would you like to peek at?", 0, this.draft.getOpposingPlayers().length);
        SGuiChoose.reveal("Peeked booster", this.peekAtBoosterPack(round, playerId));
        return true;
    }

    protected DraftPack peekAtBoosterPack(int round, int playerNumber) {
        if (this.draft.getRound() > round) {
            return null;
        }
        int relativeRound = round - this.draft.getRound();
        LimitedPlayer player = playerNumber == 0 ? this.draft.getHumanPlayer() : this.draft.getOpposingPlayers()[playerNumber - 1];
        if (relativeRound == 0) {
            return player.packQueue.peek();
        }
        return player.unopenedPacks.peek();
    }

    public boolean handleIllusionaryInformant() {
        Integer player = SGuiChoose.getInteger("Peek at another player's last pick?", 0, this.draft.getOpposingPlayers().length);
        if (Objects.equals(player, null)) {
            return false;
        }
        LimitedPlayer peekAt = this.draft.getPlayer(player);
        if (peekAt == null) {
            return false;
        }
        SGuiChoose.reveal("Player " + player + " lastPicked: ", Lists.newArrayList(peekAt.getLastPick()));
        return true;
    }

    public PaperCard handleSpirePhantasm(DraftPack chooseFrom) {
        if (chooseFrom.isEmpty()) {
            return null;
        }
        return SGuiChoose.one("Guess the next card drafted from this pack", chooseFrom);
    }

    public boolean handleLeovoldsOperative(DraftPack pack, PaperCard drafted) {
        if (Objects.equals(SGuiChoose.one("Draft an extra pick with Leovold's Operative?", Lists.newArrayList("Yes", "No")), "No")) {
            return false;
        }
        this.playerFlags |= 0x2000;
        return true;
    }

    public boolean handleCogworkLibrarian(DraftPack pack, PaperCard drafted) {
        return !Objects.equals(SGuiChoose.one("Draft an extra pick with Cogwork Librarian?", Lists.newArrayList("Yes", "No")), "No");
    }

    public boolean handleAgentOfAcquisitions(DraftPack pack, PaperCard drafted) {
        return !Objects.equals(SGuiChoose.one("Draft the rest of the pack with Agent of Acquisitions?", Lists.newArrayList("Yes", "No")), "No");
    }

    public void comparePhantasmGuess(DraftPack pack, PaperCard drafted) {
        LimitedPlayer guesser = pack.getAwaitingGuess().getKey();
        PaperCard guess = pack.getAwaitingGuess().getValue();
        this.addLog(this.name() + " reveals " + drafted.getName() + " from " + guesser.name() + "'s guess of " + guess.getName() + " with Spire Phantasm.");
        if (guess.equals(drafted)) {
            this.addLog(guesser.name() + " correctly guessed " + guess.getName() + " with Spire Phantasm.");
            guesser.getDraftNotes().computeIfAbsent("Spire Phantasm", k -> Lists.newArrayList()).add(guess.getName());
        } else {
            this.addLog(guesser.name() + " incorrectly guessed " + guess.getName() + " with Spire Phantasm.");
        }
        pack.resetAwaitingGuess();
    }

    public boolean hasArchdemonCurse() {
        return (this.playerFlags & 0x20000) == 131072;
    }

    public boolean hasBrokers() {
        return this.dealBrokers > 0;
    }

    public void reduceArchdemonOfPalianoCurse() {
        if (this.hasArchdemonCurse()) {
            this.archdemonFavors.replaceAll(integer -> integer - 1);
            this.archdemonFavors.removeIf(integer -> integer <= 0);
            if (this.archdemonFavors.isEmpty()) {
                this.playerFlags &= 0xFFFDFFFF;
            }
        }
    }

    public PaperCard pickFromArchdemonCurse(DraftPack chooseFrom) {
        Collections.shuffle(chooseFrom);
        this.reduceArchdemonOfPalianoCurse();
        return (PaperCard)chooseFrom.get(0);
    }

    public void addSingleBoosterPack() {
        ArrayList<CardEdition> possibleEditions = Lists.newArrayList(Iterables.filter(FModel.getMagicDb().getEditions(), CardEdition.Predicates.CAN_MAKE_BOOSTER));
        CardEdition edition = this.chooseEdition(possibleEditions);
        if (edition == null) {
            this.addLog(this.name() + " chose not to add a booster pack to the draft.");
            return;
        }
        this.packQueue.add(this.draft.addBooster(edition));
        this.addLog(this.name() + " added " + edition.getName() + " to be drafted this round");
    }

    protected CardEdition chooseEdition(List<CardEdition> possibleEditions) {
        return SGuiChoose.oneOrNone("Choose a booster pack to add to the draft", possibleEditions);
    }

    public void activateBrokers(List<LimitedPlayer> players) {
        while (this.dealBrokers > 0) {
            --this.dealBrokers;
            this.addLog(this.name() + " activated Deal Broker.");
            PaperCard exchangeCard = this.chooseExchangeCard(null);
            HashMap<PaperCard, LimitedPlayer> offers = new HashMap<PaperCard, LimitedPlayer>();
            for (LimitedPlayer player : players) {
                PaperCard offer;
                if (player == this || (offer = player.chooseExchangeCard(exchangeCard)) == null) continue;
                this.addLog(player.name() + " offered " + offer.getName() + " to " + this.name() + " for " + exchangeCard.getName());
                offers.put(offer, player);
            }
            PaperCard exchangeOffer = this.chooseCardToExchange(exchangeCard, offers);
            if (exchangeOffer == null) {
                this.addLog(this.name() + " chose not to accept any offers.");
                continue;
            }
            this.exchangeAcceptedOffer(exchangeCard, (LimitedPlayer)offers.get(exchangeOffer), exchangeOffer);
        }
    }

    protected PaperCard chooseExchangeCard(PaperCard offer) {
        List deckCards = this.deck.getOrCreate(DeckSection.Sideboard).toFlatList();
        if (offer == null) {
            return (PaperCard)SGuiChoose.oneOrNone("Choose a card to offer for trade: ", deckCards);
        }
        return (PaperCard)SGuiChoose.oneOrNone("Choose a card to trade for " + offer.getName() + ": ", deckCards);
    }

    protected PaperCard chooseCardToExchange(PaperCard exchangeCard, Map<PaperCard, LimitedPlayer> offers) {
        return SGuiChoose.oneOrNone("Choose a card to accept trade of " + exchangeCard + ": ", offers.keySet());
    }

    protected void exchangeAcceptedOffer(PaperCard exchangeCard, LimitedPlayer player, PaperCard offer) {
        this.addLog(this.name() + " accepted the offer of " + exchangeCard + " for " + offer + " from " + player.name() + ".");
        player.getDeck().removeCardName(offer.getName());
        player.getDeck().get(DeckSection.Sideboard).add(exchangeCard);
        this.deck.removeCardName(exchangeCard.getName());
        this.deck.get(DeckSection.Sideboard).add(offer);
        ((List)player.getDraftNotes().getOrDefault(offer.getName(), Lists.newArrayList())).forEach(note -> {
            List noteList = this.noted.computeIfAbsent(offer.getName(), k -> Lists.newArrayList());
            noteList.add(note);
        });
        ((List)this.getDraftNotes().getOrDefault(exchangeCard.getName(), Lists.newArrayList())).forEach(note -> {
            List noteList = player.getDraftNotes().computeIfAbsent(exchangeCard.getName(), k -> Lists.newArrayList());
            noteList.add(note);
        });
    }
}

