/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import forge.deck.Deck;
import forge.gamemodes.limited.DraftRankCache;
import forge.item.PaperCard;
import java.util.Comparator;
import java.util.Map;

public class LimitedDeckEvaluator {
    public static double getDeckDraftValue(Deck d) {
        double value = 0.0;
        double divider = 0.0;
        if (d.getMain().isEmpty()) {
            return 0.0;
        }
        double best = 1.0;
        for (Map.Entry kv : d.getMain()) {
            PaperCard evalCard = (PaperCard)kv.getKey();
            int count = kv.getValue();
            if (DraftRankCache.getRanking(evalCard.getName(), evalCard.getEdition()) == null) continue;
            double add = DraftRankCache.getRanking(evalCard.getName(), evalCard.getEdition());
            value += add * (double)count;
            divider += (double)count;
            if (!(best > add)) continue;
            best = add;
        }
        if (divider == 0.0 || value == 0.0) {
            return 0.0;
        }
        return 20.0 / (best + 2.0 * (value /= divider));
    }

    public static class LimitedDeckComparer
    implements Comparator<Deck> {
        @Override
        public int compare(Deck o1, Deck o2) {
            double delta = LimitedDeckEvaluator.getDeckDraftValue(o1) - LimitedDeckEvaluator.getDeckDraftValue(o2);
            if (delta > 0.0) {
                return 1;
            }
            if (delta < 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

