/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.StaticData;
import forge.card.CardEdition;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckSection;
import forge.deck.generation.DeckGenPool;
import forge.deck.generation.DeckGeneratorBase;
import forge.deck.generation.IDeckGenPool;
import forge.game.GameFormat;
import forge.gamemodes.limited.FullDeckColors;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CardThemedDeckBuilder
extends DeckGeneratorBase {
    protected int targetSize;
    protected int numSpellsNeeded;
    protected int numCreaturesToStart;
    protected int landsNeeded;
    protected PaperCard keyCard;
    protected PaperCard secondKeyCard;
    protected Predicate<CardRules> hasColor;
    protected List<PaperCard> availableList;
    protected List<PaperCard> aiPlayables;
    protected final List<PaperCard> deckList = new ArrayList<PaperCard>();
    protected final List<String> setsWithBasicLands = new ArrayList<String>();
    protected List<PaperCard> rankedColorList;
    protected boolean isForAI = false;
    protected Iterable<PaperCard> onColorCreaturesAndSpells;
    protected static final boolean logToConsole = false;
    protected static final boolean logColorsToConsole = false;
    protected Iterable<PaperCard> keyCards;
    protected Map<Integer, Integer> targetCMCs;

    @Override
    protected final float getLandPercentage() {
        return 0.41f;
    }

    @Override
    protected final float getCreaturePercentage() {
        return 0.34f;
    }

    @Override
    protected final float getSpellPercentage() {
        return 0.25f;
    }

    public CardThemedDeckBuilder(IDeckGenPool pool, DeckFormat format) {
        super(pool, format);
    }

    public CardThemedDeckBuilder(PaperCard keyCard0, PaperCard secondKeyCard0, List<PaperCard> dList, GameFormat format, boolean isForAI) {
        this(keyCard0, secondKeyCard0, dList, format, isForAI, DeckFormat.Constructed);
    }

    public CardThemedDeckBuilder(PaperCard keyCard0, PaperCard secondKeyCard0, List<PaperCard> dList, GameFormat format, boolean isForAI, DeckFormat deckFormat) {
        super(new DeckGenPool(FModel.getMagicDb().getCommonCards().getUniqueCards()), deckFormat, format.getFilterPrinted());
        this.availableList = dList;
        this.keyCard = keyCard0;
        this.secondKeyCard = secondKeyCard0;
        this.isForAI = isForAI;
        if (isForAI) {
            Iterable<PaperCard> playables = Iterables.filter(this.availableList, Predicates.compose(CardRulesPredicates.IS_KEPT_IN_AI_DECKS, PaperCard::getRules));
            this.aiPlayables = Lists.newArrayList(playables);
        } else {
            this.aiPlayables = Lists.newArrayList(this.availableList);
        }
        this.availableList.removeAll(this.aiPlayables);
        this.targetSize = deckFormat.getMainRange().getMinimum();
        FullDeckColors deckColors = new FullDeckColors();
        int cardCount = 0;
        int colourCheckAmount = 30;
        if (this.targetSize < 60) {
            colourCheckAmount = 10;
        }
        for (PaperCard c : this.getAiPlayables()) {
            if (c.getRules().getType().isLand()) continue;
            if (deckColors.canChoseMoreColors()) {
                deckColors.addColorsOf(c);
                ++cardCount;
            }
            if (cardCount <= colourCheckAmount) continue;
            break;
        }
        this.colors = deckColors.getChosenColors();
        if (!this.colors.hasAllColors(this.keyCard.getRules().getColorIdentity().getColor())) {
            this.colors = ColorSet.fromMask(this.colors.getColor() | this.keyCard.getRules().getColorIdentity().getColor());
        }
        if (this.secondKeyCard != null && !this.colors.hasAllColors(this.secondKeyCard.getRules().getColorIdentity().getColor())) {
            this.colors = ColorSet.fromMask(this.colors.getColor() | this.secondKeyCard.getRules().getColorIdentity().getColor());
        }
        this.numSpellsNeeded = Double.valueOf(Math.floor((float)this.targetSize * (this.getCreaturePercentage() + this.getSpellPercentage()))).intValue();
        this.numCreaturesToStart = Double.valueOf(Math.ceil((float)this.targetSize * this.getCreaturePercentage())).intValue();
        this.landsNeeded = Double.valueOf(Math.ceil((float)this.targetSize * this.getLandPercentage())).intValue();
        this.findBasicLandSets();
    }

    @Override
    public CardPool getDeck(int size, boolean forAi) {
        return this.buildDeck().getMain();
    }

    protected void updateColors() {
        FullDeckColors finalDeckColors = new FullDeckColors();
        for (PaperCard c : this.deckList) {
            if (!finalDeckColors.canChoseMoreColors()) continue;
            finalDeckColors.addColorsOf(c);
        }
        this.colors = finalDeckColors.getChosenColors();
    }

    public Deck buildDeck() {
        this.hasColor = Predicates.or(new MatchColorIdentity(this.colors), COLORLESS_CARDS);
        Iterable<PaperCard> colorList = Iterables.filter(this.aiPlayables, Predicates.compose(this.hasColor, PaperCard::getRules));
        this.rankedColorList = Lists.newArrayList(colorList);
        this.onColorCreaturesAndSpells = Iterables.filter(this.rankedColorList, Predicates.compose(Predicates.or(CardRulesPredicates.Presets.IS_CREATURE, CardRulesPredicates.Presets.IS_NON_CREATURE_SPELL), PaperCard::getRules));
        this.generateTargetCMCs();
        this.addKeyCards();
        this.numSpellsNeeded -= this.deckList.size();
        this.addManaCurveCards(this.onColorCreaturesAndSpells, this.numSpellsNeeded, "Creatures and Spells");
        this.addCards(this.onColorCreaturesAndSpells, this.numSpellsNeeded - this.deckList.size());
        double avCMC = CardThemedDeckBuilder.getAverageCMC(this.deckList);
        float baseLandParameter = 16.0f;
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.FILTERED_HANDS)) {
            baseLandParameter -= 1.0f;
        }
        this.landsNeeded = Double.valueOf(((double)baseLandParameter + (double)3.14f * avCMC) * (double)this.targetSize / 60.0).intValue();
        this.numSpellsNeeded = this.targetSize - this.landsNeeded;
        int extraCardsToAdd = this.numSpellsNeeded - this.deckList.size();
        if (extraCardsToAdd > 0) {
            for (int i = 0; i < extraCardsToAdd; ++i) {
                this.addLowCMCCard();
            }
        }
        this.addThirdColorCards(this.numSpellsNeeded - this.deckList.size());
        int stillNeeds = this.numSpellsNeeded - this.deckList.size();
        if (stillNeeds > 0) {
            this.addCards(this.onColorCreaturesAndSpells, stillNeeds);
        }
        if ((stillNeeds = this.numSpellsNeeded - this.deckList.size()) > 0) {
            this.extendPlaysets(stillNeeds);
        }
        if ((stillNeeds = this.numSpellsNeeded - this.deckList.size()) > 0) {
            this.addRandomCards(stillNeeds);
        }
        this.updateColors();
        this.addLandKeyCards();
        List<String> duals = this.getDualLandList(this.isForAI ? CardRulesPredicates.IS_KEPT_IN_AI_DECKS : Predicates.alwaysTrue());
        this.addNonBasicLands();
        this.checkEvolvingWilds();
        int[] clrCnts = this.calculateLandNeeds();
        if (clrCnts.length > 1) {
            for (String s2 : duals) {
                this.cardCounts.put(s2, 0);
            }
        }
        if (this.landsNeeded > 0) {
            this.addLands(clrCnts);
        }
        this.addWastesIfRequired();
        this.fixDeckSize();
        Deck result = new Deck(this.generateName());
        result.getMain().add((Iterable<PaperCard>)this.deckList);
        CardPool cp = result.getOrCreate(DeckSection.Sideboard);
        Iterable<PaperCard> potentialSideboard = Iterables.filter(this.aiPlayables, Predicates.and(Predicates.compose(this.hasColor, PaperCard::getRules), Predicates.compose(CardRulesPredicates.Presets.IS_NON_LAND, PaperCard::getRules)));
        for (int i = 0; i < 15 && potentialSideboard.iterator().hasNext(); ++i) {
            PaperCard sbCard = potentialSideboard.iterator().next();
            cp.add(sbCard);
            this.aiPlayables.remove(sbCard);
            this.rankedColorList.remove(sbCard);
        }
        return result;
    }

    protected void extendPlaysets(int numSpellsNeeded) {
        HashMap<PaperCard, Integer> currentCounts = new HashMap<PaperCard, Integer>();
        ArrayList<PaperCard> cardsToAdd = new ArrayList<PaperCard>();
        int i = 0;
        for (PaperCard card : this.deckList) {
            if (card.getRules().getType().isLand()) continue;
            if (currentCounts.containsKey(card)) {
                currentCounts.put(card, (Integer)currentCounts.get(card) + 1);
                continue;
            }
            currentCounts.put(card, 1);
        }
        for (PaperCard card : currentCounts.keySet()) {
            if ((Integer)currentCounts.get(card) != 2 && (Integer)currentCounts.get(card) != 3) continue;
            cardsToAdd.add(card);
            if (++i < numSpellsNeeded) continue;
            break;
        }
        this.deckList.addAll(cardsToAdd);
        this.aiPlayables.removeAll(cardsToAdd);
        this.rankedColorList.removeAll(cardsToAdd);
    }

    protected void generateTargetCMCs() {
        this.targetCMCs = new HashMap<Integer, Integer>();
        this.targetCMCs.put(1, Math.round((MyRandom.getRandom().nextInt(16) + 2) * this.targetSize / 60));
        this.targetCMCs.put(2, Math.round((MyRandom.getRandom().nextInt(20) + 6) * this.targetSize / 60));
        this.targetCMCs.put(3, Math.round((MyRandom.getRandom().nextInt(10) + 8) * this.targetSize / 60));
        this.targetCMCs.put(4, Math.round((MyRandom.getRandom().nextInt(8) + 6) * this.targetSize / 60));
        this.targetCMCs.put(5, Math.round((MyRandom.getRandom().nextInt(8) + 6) * this.targetSize / 60));
        this.targetCMCs.put(6, Math.round((MyRandom.getRandom().nextInt(8) + 6) * this.targetSize / 60));
        while (this.sumMapValues(this.targetCMCs) < this.numSpellsNeeded) {
            int randomKey = MyRandom.getRandom().nextInt(6) + 1;
            this.targetCMCs.put(randomKey, this.targetCMCs.get(randomKey) + 1);
        }
    }

    private int sumMapValues(Map<Integer, Integer> integerMap) {
        int sum = 0;
        Iterator<Integer> iterator = integerMap.values().iterator();
        while (iterator.hasNext()) {
            float f = iterator.next().intValue();
            sum = (int)((float)sum + f);
        }
        return sum;
    }

    protected void addKeyCards() {
        if (!this.keyCard.getRules().getMainPart().getType().isLand()) {
            this.keyCards = Iterables.filter(this.aiPlayables, IPaperCard.Predicates.name(this.keyCard.getName()));
            ArrayList<PaperCard> keyCardList = Lists.newArrayList(this.keyCards);
            this.deckList.addAll(keyCardList);
            this.aiPlayables.removeAll(keyCardList);
            this.rankedColorList.removeAll(keyCardList);
        }
        if (this.secondKeyCard != null && !this.secondKeyCard.getRules().getMainPart().getType().isLand()) {
            Iterable<PaperCard> secondKeyCards = Iterables.filter(this.aiPlayables, IPaperCard.Predicates.name(this.secondKeyCard.getName()));
            ArrayList<PaperCard> keyCardList = Lists.newArrayList(secondKeyCards);
            this.deckList.addAll(keyCardList);
            this.aiPlayables.removeAll(keyCardList);
            this.rankedColorList.removeAll(keyCardList);
        }
    }

    protected void addLandKeyCards() {
        if (this.keyCard.getRules().getMainPart().getType().isLand()) {
            this.keyCards = Iterables.filter(this.aiPlayables, IPaperCard.Predicates.name(this.keyCard.getName()));
            ArrayList<PaperCard> keyCardList = Lists.newArrayList(this.keyCards);
            this.deckList.addAll(keyCardList);
            this.aiPlayables.removeAll(keyCardList);
            this.rankedColorList.removeAll(keyCardList);
            --this.landsNeeded;
        }
        if (this.secondKeyCard != null && this.secondKeyCard.getRules().getMainPart().getType().isLand()) {
            Iterable<PaperCard> secondKeyCards = Iterables.filter(this.aiPlayables, IPaperCard.Predicates.name(this.secondKeyCard.getName()));
            ArrayList<PaperCard> keyCardList = Lists.newArrayList(secondKeyCards);
            this.deckList.addAll(keyCardList);
            this.aiPlayables.removeAll(keyCardList);
            this.rankedColorList.removeAll(keyCardList);
            --this.landsNeeded;
        }
    }

    protected void checkEvolvingWilds() {
        ArrayList<PaperCard> evolvingWilds = Lists.newArrayList(Iterables.filter(this.deckList, IPaperCard.Predicates.name("Evolving Wilds")));
        if (evolvingWilds.size() > 0 && this.landsNeeded < 4 || this.colors.countColors() < 2) {
            this.deckList.removeAll(evolvingWilds);
            this.landsNeeded += evolvingWilds.size();
            this.aiPlayables.addAll(evolvingWilds);
        }
    }

    protected void addThirdColorCards(int num) {
        if (num > 0) {
            Iterable<PaperCard> others = Iterables.filter(this.aiPlayables, Predicates.compose(CardRulesPredicates.Presets.IS_NON_LAND, PaperCard::getRules));
            ArrayList<PaperCard> toAdd = new ArrayList<PaperCard>();
            for (PaperCard card : others) {
                ColorSet off = this.colors.getOffColors(card.getRules().getColor());
                if (!off.isMonoColor()) continue;
                this.colors = ColorSet.fromMask(this.colors.getColor() | off.getColor());
                break;
            }
            this.hasColor = Predicates.and(CardRulesPredicates.Presets.IS_NON_LAND, Predicates.or(new MatchColorIdentity(this.colors), DeckGeneratorBase.COLORLESS_CARDS));
            Iterable<PaperCard> threeColorList = Iterables.filter(this.aiPlayables, Predicates.compose(this.hasColor, PaperCard::getRules));
            for (PaperCard card : threeColorList) {
                if (num <= 0) break;
                toAdd.add(card);
                --num;
            }
            this.deckList.addAll(toAdd);
            this.aiPlayables.removeAll(toAdd);
        }
    }

    protected void addLowCMCCard() {
        Iterable<PaperCard> nonLands = Iterables.filter(this.rankedColorList, Predicates.compose(CardRulesPredicates.Presets.IS_NON_LAND, PaperCard::getRules));
        PaperCard card = Iterables.getFirst(nonLands, null);
        if (card != null) {
            this.deckList.add(card);
            this.aiPlayables.remove(card);
            this.rankedColorList.remove(card);
        }
    }

    @Override
    protected boolean setBasicLandPool(String edition) {
        Predicate<PaperCard> isSetBasicLand = edition != null ? Predicates.and(IPaperCard.Predicates.printedInSet(edition), Predicates.compose(CardRulesPredicates.Presets.IS_BASIC_LAND, PaperCard::getRules)) : Predicates.compose(CardRulesPredicates.Presets.IS_BASIC_LAND, PaperCard::getRules);
        this.landPool = new DeckGenPool(this.format.getCardPool(this.fullCardDB).getAllCards(isSetBasicLand));
        return this.landPool.contains("Plains");
    }

    protected String generateName() {
        if (this.secondKeyCard != null) {
            return this.keyCard.getName() + " - " + this.secondKeyCard.getName() + " based deck";
        }
        return this.keyCard.getName() + " based deck";
    }

    private void debugFinalDeck() {
        int i = 0;
        System.out.println("DECK");
        for (PaperCard c : this.deckList) {
            System.out.println(++i + ". " + c.toString() + ": " + c.getRules().getManaCost().toString());
        }
        i = 0;
        System.out.println("NOT PLAYABLE");
        for (PaperCard c : this.availableList) {
            System.out.println(++i + ". " + c.toString() + ": " + c.getRules().getManaCost().toString());
        }
        i = 0;
        System.out.println("NOT PICKED");
        for (PaperCard c : this.aiPlayables) {
            System.out.println(++i + ". " + c.toString() + ": " + c.getRules().getManaCost().toString());
        }
    }

    private Set<String> getDeckListNames() {
        HashSet<String> deckListNames = new HashSet<String>();
        for (PaperCard card : this.deckList) {
            deckListNames.add(card.getName());
        }
        return deckListNames;
    }

    private void fixDeckSize() {
        while (this.deckList.size() > this.targetSize) {
            PaperCard c = this.deckList.get(MyRandom.getRandom().nextInt(this.deckList.size() - 1));
            this.deckList.remove(c);
            this.aiPlayables.add(c);
        }
        if (this.deckList.size() == this.targetSize) {
            return;
        }
        int stillNeeds = this.targetSize - this.deckList.size();
        if (stillNeeds > 0) {
            this.addCards(this.onColorCreaturesAndSpells, stillNeeds);
        }
        if ((stillNeeds = this.targetSize - this.deckList.size()) > 0) {
            this.extendPlaysets(stillNeeds);
        }
        if ((stillNeeds = this.targetSize - this.deckList.size()) == 0) {
            return;
        }
        Predicate<PaperCard> possibleFromFullPool = new Predicate<PaperCard>(){
            final Set<String> deckListNames;
            {
                this.deckListNames = CardThemedDeckBuilder.this.getDeckListNames();
            }

            @Override
            public boolean apply(PaperCard card) {
                return CardThemedDeckBuilder.this.format.isLegalCard(card) && card.getRules().getColorIdentity().hasNoColorsExcept(CardThemedDeckBuilder.this.colors) && !this.deckListNames.contains(card.getName()) && !card.getRules().getAiHints().getRemAIDecks() && !card.getRules().getAiHints().getRemRandomDecks() && !card.getRules().getMainPart().getType().isLand();
            }
        };
        ArrayList<PaperCard> possibleList = Lists.newArrayList(this.pool.getAllCards(possibleFromFullPool));
        if (this.keyCard != null) {
            possibleList.removeAll(StaticData.instance().getCommonCards().getAllCards(this.keyCard.getName()));
        }
        if (this.secondKeyCard != null) {
            possibleList.removeAll(StaticData.instance().getCommonCards().getAllCards(this.secondKeyCard.getName()));
        }
        Collections.shuffle(possibleList);
        Iterator iRandomPool = possibleList.iterator();
        while (this.deckList.size() < this.targetSize) {
            PaperCard randomCard = (PaperCard)iRandomPool.next();
            this.deckList.add(randomCard);
        }
    }

    protected void findBasicLandSets() {
        HashSet<String> sets = new HashSet<String>();
        for (PaperCard cp : this.aiPlayables) {
            CardEdition ee = FModel.getMagicDb().getEditions().get(cp.getEdition());
            if (sets.contains(cp.getEdition()) || !CardEdition.Predicates.hasBasicLands.apply(ee)) continue;
            sets.add(cp.getEdition());
        }
        this.setsWithBasicLands.addAll(sets);
        if (this.setsWithBasicLands.isEmpty()) {
            this.setsWithBasicLands.add("BFZ");
        }
    }

    private void addLands(int[] clrCnts) {
        float p;
        int nLand;
        int i;
        Iterable<PaperCard> basicLands = Iterables.filter(this.aiPlayables, Predicates.compose(CardRulesPredicates.Presets.IS_BASIC_LAND, PaperCard::getRules));
        int totalColor = 0;
        int numColors = 0;
        for (i = 0; i < 5; ++i) {
            totalColor += clrCnts[i];
            if (clrCnts[i] <= 0) continue;
            ++numColors;
        }
        for (i = 0; i < 5; ++i) {
            if (clrCnts[i] <= 0 || (nLand = Math.round((float)this.landsNeeded * (p = (float)clrCnts[i] / (float)totalColor))) <= 0) continue;
            this.deckList.add(this.getBasicLand(i));
            --this.landsNeeded;
        }
        for (i = 0; i < 5; ++i) {
            if (clrCnts[i] <= 0) continue;
            p = (float)clrCnts[i] / (float)totalColor;
            nLand = Math.round((float)this.landsNeeded * p);
            for (int j = 0; j < nLand; ++j) {
                this.deckList.add(this.getBasicLand(i));
            }
        }
        while (this.deckList.size() > this.targetSize) {
            this.deckList.remove(this.deckList.size() - 1);
        }
    }

    protected PaperCard getBasicLand(int basicLand) {
        String set = this.setsWithBasicLands.size() > 1 ? this.setsWithBasicLands.get(MyRandom.getRandom().nextInt(this.setsWithBasicLands.size() - 1)) : this.setsWithBasicLands.get(0);
        return FModel.getMagicDb().getCommonCards().getCard((String)MagicColor.Constant.BASIC_LANDS.get(basicLand), set);
    }

    private void addWastesIfRequired() {
        PaperCard waste = FModel.getMagicDb().getCommonCards().getUniqueByName("Wastes");
        if (this.colors.isColorless() && this.keyCard.getRules().getColorIdentity().isColorless() && this.format.isLegalCard(waste)) {
            while (this.landsNeeded > 0) {
                this.deckList.add(waste);
                --this.landsNeeded;
                this.aiPlayables.remove(waste);
                this.rankedColorList.remove(waste);
            }
        }
    }

    private int[] calculateLandNeeds() {
        int[] clrCnts = new int[]{0, 0, 0, 0, 0};
        if (this.format.equals((Object)DeckFormat.Brawl) && this.keyCard.getRules().getColorIdentity().isColorless()) {
            clrCnts[MyRandom.getRandom().nextInt((int)5)] = 1;
            return clrCnts;
        }
        for (PaperCard cp : this.deckList) {
            ManaCost mc = cp.getRules().getManaCost();
            for (ManaCostShard shard : mc) {
                for (int i = 0; i < MagicColor.WUBRG.length; ++i) {
                    byte c = MagicColor.WUBRG[i];
                    if (!shard.canBePaidWithManaOfColor(c) || !this.colors.hasAnyColor(c)) continue;
                    int n = i;
                    clrCnts[n] = clrCnts[n] + 1;
                }
            }
        }
        for (int i = 0; i < MagicColor.WUBRG.length; ++i) {
            byte c = MagicColor.WUBRG[i];
            if (!this.colors.hasAnyColor(c) || clrCnts[i] != 0) continue;
            int n = i;
            clrCnts[n] = clrCnts[n] + 1;
        }
        return clrCnts;
    }

    private boolean containsTronLands(Iterable<PaperCard> cards) {
        for (PaperCard card : cards) {
            if (!card.getRules().getType().isLand() || !card.getName().equals("Urza's Mine") && !card.getName().equals("Urza's Tower") && !card.getName().equals("Urza's Power Plant")) continue;
            return true;
        }
        return false;
    }

    private void addNonBasicLands() {
        Iterable<PaperCard> lands = Iterables.filter(this.aiPlayables, Predicates.compose(CardRulesPredicates.Presets.IS_NONBASIC_LAND, PaperCard::getRules));
        ArrayList<PaperCard> landsToAdd = new ArrayList<PaperCard>();
        if (this.colors.isColorless()) {
            boolean bl = false;
        }
        int minBasics = this.containsTronLands(lands) ? Math.round((float)(MyRandom.getRandom().nextInt(5) + 3) * (float)this.targetSize / 60.0f) : (this.colors.isMonoColor() ? Math.round((float)(MyRandom.getRandom().nextInt(15) + 9) * (float)this.targetSize / 60.0f) : Math.round((float)(MyRandom.getRandom().nextInt(8) + 6) * (float)this.targetSize / 60.0f));
        lands = Iterables.filter(this.aiPlayables, Predicates.compose(CardRulesPredicates.Presets.IS_NONBASIC_LAND, PaperCard::getRules));
        for (PaperCard card : lands) {
            if (this.landsNeeded <= minBasics || !card.getRules().getDeckbuildingColors().hasNoColorsExcept(this.colors)) continue;
            landsToAdd.add(card);
            --this.landsNeeded;
        }
        this.deckList.addAll(landsToAdd);
        this.aiPlayables.removeAll(landsToAdd);
        this.rankedColorList.removeAll(landsToAdd);
    }

    private void addRandomCards(int num) {
        Set<String> deckListNames = this.getDeckListNames();
        Predicate possibleFromFullPool = card -> this.format.isLegalCard((PaperCard)card) && card.getRules().getColorIdentity().hasNoColorsExcept(this.colors) && !deckListNames.contains(card.getName()) && !card.getRules().getAiHints().getRemAIDecks() && !card.getRules().getAiHints().getRemRandomDecks() && !card.getRules().getMainPart().getType().isLand();
        ArrayList<PaperCard> possibleList = Lists.newArrayList(this.pool.getAllCards(possibleFromFullPool));
        if (this.keyCard != null) {
            possibleList.removeAll(StaticData.instance().getCommonCards().getAllCards(this.keyCard.getName()));
        }
        if (this.secondKeyCard != null) {
            possibleList.removeAll(StaticData.instance().getCommonCards().getAllCards(this.secondKeyCard.getName()));
        }
        Collections.shuffle(possibleList);
        this.addManaCurveCards(possibleList, num, "Random Card");
    }

    private void addCards(Iterable<PaperCard> cards, int num) {
        ArrayList<PaperCard> cardsToAdd = new ArrayList<PaperCard>();
        for (PaperCard card : cards) {
            if (card.getRules().getMainPart().getType().isLand()) continue;
            if (num <= 0) break;
            cardsToAdd.add(card);
            --num;
        }
        this.deckList.addAll(cardsToAdd);
        this.aiPlayables.removeAll(cardsToAdd);
        this.rankedColorList.removeAll(cardsToAdd);
    }

    private void addManaCurveCards(Iterable<PaperCard> creatures, int num, String nameForLog) {
        HashMap<Integer, Integer> creatureCosts = new HashMap<Integer, Integer>();
        for (int i = 1; i < 7; ++i) {
            creatureCosts.put(i, 0);
        }
        Predicate filter = Predicates.compose(CardRulesPredicates.Presets.IS_CREATURE, PaperCard::getRules);
        for (IPaperCard iPaperCard : Iterables.filter(this.deckList, filter)) {
            int cmc = iPaperCard.getRules().getManaCost().getCMC();
            if (cmc < 1) {
                cmc = 1;
            } else if (cmc > 6) {
                cmc = 6;
            }
            creatureCosts.put(cmc, (Integer)creatureCosts.get(cmc) + 1);
        }
        ArrayList<PaperCard> creaturesToAdd = new ArrayList<PaperCard>();
        for (PaperCard card : creatures) {
            int cmc = card.getRules().getManaCost().getCMC();
            if (cmc < 1) {
                cmc = 1;
            } else if (cmc > 6) {
                cmc = 6;
            }
            Integer currentAtCmc = (Integer)creatureCosts.get(cmc);
            boolean willAddCreature = false;
            if (cmc <= 1 && currentAtCmc < this.targetCMCs.get(1)) {
                willAddCreature = true;
            } else if (cmc == 2 && currentAtCmc < this.targetCMCs.get(2)) {
                willAddCreature = true;
            } else if (cmc == 3 && currentAtCmc < this.targetCMCs.get(3)) {
                willAddCreature = true;
            } else if (cmc == 4 && currentAtCmc < this.targetCMCs.get(4)) {
                willAddCreature = true;
            } else if (cmc == 5 && currentAtCmc < this.targetCMCs.get(5)) {
                willAddCreature = true;
            } else if (cmc >= 6 && currentAtCmc < this.targetCMCs.get(6)) {
                willAddCreature = true;
            }
            if (willAddCreature) {
                creaturesToAdd.add(card);
                --num;
                creatureCosts.put(cmc, (Integer)creatureCosts.get(cmc) + 1);
            }
            if (num > 0) continue;
            break;
        }
        this.deckList.addAll(creaturesToAdd);
        this.aiPlayables.removeAll(creaturesToAdd);
        this.rankedColorList.removeAll(creaturesToAdd);
    }

    private static double getAverageCMC(List<PaperCard> cards) {
        double sum = 0.0;
        for (IPaperCard iPaperCard : cards) {
            sum += (double)iPaperCard.getRules().getManaCost().getCMC();
        }
        return sum / (double)cards.size();
    }

    private static int getMaxCMC(List<PaperCard> cards) {
        int max = 0;
        for (IPaperCard iPaperCard : cards) {
            if (iPaperCard.getRules().getManaCost().getCMC() <= max) continue;
            max = iPaperCard.getRules().getManaCost().getCMC();
        }
        return max;
    }

    public ColorSet getColors() {
        return this.colors;
    }

    public void setColors(ColorSet colors0) {
        this.colors = colors0;
    }

    public List<PaperCard> getAiPlayables() {
        return this.aiPlayables;
    }

    public static class MatchColorIdentity
    implements Predicate<CardRules> {
        private final ColorSet allowedColor;

        public MatchColorIdentity(ColorSet color) {
            this.allowedColor = color;
        }

        @Override
        public boolean apply(CardRules subject) {
            return this.allowedColor.containsAllColorsFrom(subject.getColorIdentity().getColor());
        }
    }
}

