/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.card.ColorSet;
import forge.card.DeckHints;
import forge.card.MagicColor;
import forge.gamemodes.limited.CardRankingComparator;
import forge.gamemodes.limited.DraftRankCache;
import forge.gamemodes.limited.IBoosterDraft;
import forge.item.PaperCard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class CardRanker {
    private static final double SCORE_UNPICKABLE = -100.0;
    private static final Map<DeckHints.Type, Integer> typeFactors = ImmutableMap.builder().put(DeckHints.Type.ABILITY, 3).put(DeckHints.Type.COLOR, 1).put(DeckHints.Type.KEYWORD, 3).put(DeckHints.Type.NAME, 10).put(DeckHints.Type.TYPE, 3).build();
    private static final Map<DeckHints.Type, Integer> typeThresholds = ImmutableMap.builder().put(DeckHints.Type.ABILITY, 5).put(DeckHints.Type.COLOR, 10).put(DeckHints.Type.KEYWORD, 8).put(DeckHints.Type.NAME, 2).put(DeckHints.Type.TYPE, 8).build();
    private static boolean logToConsole = false;

    public static List<PaperCard> rankCardsInDeck(Iterable<PaperCard> cards) {
        List<Pair<Double, PaperCard>> cardScores = CardRanker.getScores(cards);
        return CardRanker.sortAndCreateList(cardScores);
    }

    public static List<PaperCard> rankCardsInPack(Iterable<PaperCard> cardsInPack, List<PaperCard> deck, ColorSet chosenColors, boolean canAddMoreColors) {
        List<Pair<Double, PaperCard>> cardScores = CardRanker.getScoresForPack(cardsInPack, deck, chosenColors, canAddMoreColors);
        return CardRanker.sortAndCreateList(cardScores);
    }

    public static List<Pair<Double, PaperCard>> getScores(Iterable<PaperCard> cards) {
        ArrayList<Pair<Double, PaperCard>> cardScores = new ArrayList<Pair<Double, PaperCard>>();
        ArrayList<PaperCard> cache = Lists.newArrayList(cards);
        for (int i = 0; i < cache.size(); ++i) {
            PaperCard card = (PaperCard)cache.get(i);
            double score = CardRanker.getRawScore(card);
            if (card.getRules().getAiHints().getRemAIDecks()) {
                score -= 20.0;
            }
            List<PaperCard> otherCards = CardRanker.getCardsExceptOne(cache, i);
            cardScores.add(Pair.of(score += CardRanker.getScoreForDeckHints(card, otherCards), card));
        }
        return cardScores;
    }

    private static List<Pair<Double, PaperCard>> getScoresForPack(Iterable<PaperCard> cardsInPack, List<PaperCard> deck, ColorSet chosenColors, boolean canAddMoreColors) {
        ArrayList<Pair<Double, PaperCard>> cardScores = new ArrayList<Pair<Double, PaperCard>>();
        for (PaperCard card : cardsInPack) {
            double score = CardRanker.getRawScore(card);
            if (card.getRules().getAiHints().getRemAIDecks()) {
                score -= 20.0;
            }
            if (!canAddMoreColors && !card.getRules().getDeckbuildingColors().hasNoColorsExcept(chosenColors)) {
                score -= 50.0;
            }
            cardScores.add(Pair.of(score += CardRanker.getScoreForDeckHints(card, deck), card));
        }
        return cardScores;
    }

    public static List<PaperCard> getOrderedRawScores(List<PaperCard> cards) {
        ArrayList<Pair<Double, PaperCard>> cardScores = Lists.newArrayList();
        for (PaperCard card : cards) {
            cardScores.add(Pair.of(CardRanker.getRawScore(card), card));
        }
        cardScores.sort(Collections.reverseOrder(new CardRankingComparator()));
        ArrayList<PaperCard> rankedCards = new ArrayList<PaperCard>(cardScores.size());
        for (Pair pair : cardScores) {
            rankedCards.add((PaperCard)pair.getValue());
        }
        return rankedCards;
    }

    public static double getRawScore(PaperCard card) {
        double rawScore;
        if (MagicColor.Constant.BASIC_LANDS.contains(card.getName())) {
            rawScore = -100.0;
        } else {
            Double rkg;
            String customRankings = IBoosterDraft.CUSTOM_RANKINGS_FILE[0];
            if (customRankings != null) {
                rkg = DraftRankCache.getCustomRanking(customRankings, card.getName());
                if (rkg == null && (rkg = DraftRankCache.getRanking(card.getName(), card.getEdition())) != null) {
                    rkg = rkg + 1.0;
                }
                if (rkg != null) {
                    rkg = rkg / 2.0;
                }
            } else {
                rkg = DraftRankCache.getRanking(card.getName(), card.getEdition());
            }
            rawScore = rkg != null ? 100.0 - 100.0 * rkg : -100.0;
        }
        return rawScore;
    }

    private static List<PaperCard> getCardsExceptOne(List<PaperCard> cache, int i) {
        ArrayList<PaperCard> otherCards = new ArrayList<PaperCard>(cache.subList(0, i));
        if (i + 1 < cache.size()) {
            otherCards.addAll(cache.subList(i + 1, cache.size()));
        }
        return otherCards;
    }

    private static double getScoreForDeckHints(PaperCard card, Iterable<PaperCard> otherCards) {
        double score = 0.0;
        ArrayList<PaperCard> toBeRanked = Lists.newArrayList(card);
        for (PaperCard other : otherCards) {
            DeckHints hints = other.getRules().getAiHints().getDeckHints();
            if (hints == null || !hints.isValid()) continue;
            Map<DeckHints.Type, Iterable<PaperCard>> cardsByType = hints.filterByType(toBeRanked);
            for (DeckHints.Type type : cardsByType.keySet()) {
                Iterable<PaperCard> cards = cardsByType.get((Object)type);
                score += (double)(Iterables.size(cards) * typeFactors.get((Object)type));
                if (!logToConsole || Iterables.size(cards) <= 0) continue;
                System.out.println(" - " + card.getName() + ": Found " + Iterables.size(cards) + " cards for " + (Object)((Object)type));
            }
        }
        DeckHints needs = card.getRules().getAiHints().getDeckNeeds();
        if (needs != null && needs.isValid()) {
            Map<DeckHints.Type, Iterable<PaperCard>> cardsByType = needs.filterByType(otherCards);
            for (DeckHints.Type type : cardsByType.keySet()) {
                Iterable<PaperCard> cards = cardsByType.get((Object)type);
                score -= (double)Math.max(typeThresholds.get((Object)type) - Iterables.size(cards), 0) / (double)typeThresholds.get((Object)type).intValue() * (double)typeFactors.get((Object)type).intValue();
                if (!logToConsole || Iterables.size(cards) <= 0) continue;
                System.out.println(" - " + card.getName() + ": Found " + Iterables.size(cards) + " cards for " + (Object)((Object)type));
            }
        }
        return score;
    }

    private static List<PaperCard> sortAndCreateList(List<Pair<Double, PaperCard>> cardScores) {
        cardScores.sort(Collections.reverseOrder(new CardRankingComparator()));
        ArrayList<PaperCard> rankedCards = new ArrayList<PaperCard>(cardScores.size());
        for (Pair<Double, PaperCard> pair : cardScores) {
            rankedCards.add(pair.getValue());
            if (!logToConsole) continue;
            System.out.println(pair.getValue().getName() + "[" + pair.getKey().toString() + "]");
        }
        return rankedCards;
    }
}

