/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.limited;

import forge.card.MagicColor;
import forge.deck.DeckFormat;
import forge.deck.io.Archetype;
import forge.game.GameFormat;
import forge.gamemodes.limited.CardThemedDeckBuilder;
import forge.item.PaperCard;
import forge.model.FModel;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class ArchetypeDeckBuilder
extends CardThemedDeckBuilder {
    private Archetype archetype;
    private boolean needsSnowLands = false;

    public ArchetypeDeckBuilder(Archetype archetype0, PaperCard keyCard0, List<PaperCard> dList, GameFormat format, boolean isForAI) {
        super(keyCard0, null, dList, format, isForAI, DeckFormat.Constructed);
        this.archetype = archetype0;
        for (Pair<String, Double> pair : this.archetype.getCardProbabilities()) {
            for (int i = 0; i < 5; ++i) {
                if (!pair.getLeft().equals(MagicColor.Constant.SNOW_LANDS.get(i)) || !(pair.getRight() > 0.04)) continue;
                this.needsSnowLands = true;
                return;
            }
        }
    }

    @Override
    protected String generateName() {
        return this.archetype.getName() + " Generated Deck";
    }

    @Override
    protected PaperCard getBasicLand(int basicLand) {
        if (this.needsSnowLands) {
            for (String landSet : this.setsWithBasicLands) {
                PaperCard land = FModel.getMagicDb().getCommonCards().getCard((String)MagicColor.Constant.SNOW_LANDS.get(basicLand), landSet);
                if (land == null) continue;
                return land;
            }
        }
        return super.getBasicLand(basicLand);
    }
}

