/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.gauntlet;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.gamemodes.gauntlet.GauntletData;
import forge.gui.error.BugReporter;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.util.IgnoringXStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;

public class GauntletIO {
    public static final String TXF_PROMPT = "[New Gauntlet]";
    public static final String SUFFIX_DATA = ".dat";
    public static final String PREFIX_QUICK = "Quick_";
    public static final String PREFIX_CUSTOM = "Custom_";
    public static final String PREFIX_COMMANDER = "Commander_";
    public static final String PREFIX_LOCKED = "LOCKED_";

    protected static XStream getSerializer(boolean isIgnoring) {
        XStream xStream = isIgnoring ? new IgnoringXStream() : new XStream();
        xStream.addPermission(NoTypePermission.NONE);
        xStream.addPermission(NullPermission.NULL);
        xStream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xStream.allowTypeHierarchy(String.class);
        xStream.allowTypeHierarchy(EnumMap.class);
        xStream.allowTypeHierarchy(ArrayList.class);
        xStream.allowTypeHierarchy(CardPool.class);
        xStream.allowTypeHierarchy(SortedSet.class);
        xStream.allowTypeHierarchy(Deck.class);
        xStream.allowTypeHierarchy(TreeMap.class);
        xStream.allowTypeHierarchy(List.class);
        xStream.allowTypeHierarchy(DeckSection.class);
        xStream.ignoreUnknownElements();
        xStream.setMode(1001);
        xStream.omitField(Deck.class, "unplayableAI");
        xStream.allowTypesByWildcard(new String[]{GauntletIO.class.getPackage().getName() + ".*", String.class.getPackage().getName() + ".*"});
        xStream.registerConverter(new DeckSectionToXml());
        xStream.autodetectAnnotations(true);
        xStream.aliasPackage("forge.gauntlet", GauntletIO.class.getPackage().getName());
        return xStream;
    }

    public static File getGauntletFile(String name) {
        return new File(ForgeConstants.GAUNTLET_DIR.userPrefLoc, name + SUFFIX_DATA);
    }

    public static File getGauntletFile(GauntletData gd) {
        return GauntletIO.getGauntletFile(gd.getName());
    }

    public static File[] getGauntletFilesUnlocked(String prefix) {
        FilenameFilter filter = (dir, name) -> (prefix == null || name.startsWith(prefix)) && name.endsWith(SUFFIX_DATA);
        File folder = new File(ForgeConstants.GAUNTLET_DIR.userPrefLoc);
        return folder.listFiles(filter);
    }

    public static File[] getGauntletFilesLocked() {
        FilenameFilter filter = (dir, name) -> name.startsWith(PREFIX_LOCKED) && name.endsWith(SUFFIX_DATA);
        File folder = new File(ForgeConstants.GAUNTLET_DIR.defaultLoc);
        return folder.listFiles(filter);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static GauntletData loadGauntlet(File xmlSaveFile) {
        boolean isCorrupt = false;
        try (GZIPInputStream zin = new GZIPInputStream(Files.newInputStream(xmlSaveFile.toPath(), new OpenOption[0]));){
            GauntletData gauntletData;
            try (InputStreamReader reader = new InputStreamReader(zin);){
                GauntletData data = (GauntletData)GauntletIO.getSerializer(true).fromXML(reader);
                String filename = xmlSaveFile.getName();
                data.setName(filename.substring(0, filename.length() - SUFFIX_DATA.length()));
                gauntletData = data;
            }
            return gauntletData;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ConversionException e) {
            BugReporter.reportException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            isCorrupt = true;
        }
        if (isCorrupt) {
            try {
                xmlSaveFile.delete();
            }
            catch (Exception e) {
                System.out.println("error delete corrupt gauntlet file: " + e);
            }
        }
        return null;
    }

    public static void saveGauntlet(GauntletData gd0) {
        try {
            XStream xStream = GauntletIO.getSerializer(false);
            GauntletIO.savePacked(xStream, gd0);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void savePacked(XStream xStream0, GauntletData gd0) throws IOException {
        try (BufferedOutputStream bout = new BufferedOutputStream(Files.newOutputStream(GauntletIO.getGauntletFile(gd0).toPath(), new OpenOption[0]));
             GZIPOutputStream zout = new GZIPOutputStream(bout);){
            xStream0.toXML((Object)gd0, zout);
            zout.flush();
        }
    }

    private static class DeckSectionToXml
    implements Converter {
        private DeckSectionToXml() {
        }

        @Override
        public boolean canConvert(Class clasz) {
            return clasz.equals(CardPool.class);
        }

        @Override
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            for (Map.Entry e : (CardPool)source) {
                DeckSectionToXml.writeCardPrinted((PaperCard)e.getKey(), e.getValue(), writer);
            }
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            CardPool result = new CardPool();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String sCnt = reader.getAttribute("n");
                int cnt = StringUtils.isNumeric(sCnt) ? Integer.parseInt(sCnt) : 1;
                String nodename = reader.getNodeName();
                if ("string".equals(nodename)) {
                    result.add(FModel.getMagicDb().getCommonCards().getCard(reader.getValue()));
                } else if ("card".equals(nodename)) {
                    result.add(DeckSectionToXml.readCardPrinted(reader), cnt);
                }
                reader.moveUp();
            }
            return result;
        }

        private static void writeCardPrinted(PaperCard cref, Integer count, HierarchicalStreamWriter writer) {
            writer.startNode("card");
            writer.addAttribute("c", cref.getName());
            writer.addAttribute("s", cref.getEdition());
            if (cref.isFoil()) {
                writer.addAttribute("foil", "1");
            }
            writer.addAttribute("i", Integer.toString(cref.getArtIndex()));
            writer.addAttribute("n", count.toString());
            writer.endNode();
        }

        private static PaperCard readCardPrinted(HierarchicalStreamReader reader) {
            String name = reader.getAttribute("c");
            String set = reader.getAttribute("s");
            String sIndex = reader.getAttribute("i");
            short index = StringUtils.isNumeric(sIndex) ? Short.parseShort(sIndex) : (short)0;
            boolean foil = "1".equals(reader.getAttribute("foil"));
            PaperCard card = FModel.getMagicDb().getOrLoadCommonCard(name, set, index, foil);
            if (null == card && (card = FModel.getMagicDb().getCommonCards().getCard(name)) == null) {
                System.err.println("Warning: Unsupported card found in gauntlet save: " + name + " from edition " + set + ". It will be removed from the gauntlet save.");
            }
            return card;
        }
    }
}

