/*
 * Decompiled with CFR 0.152.
 */
package forge.gamemodes.gauntlet;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import forge.deck.Deck;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.gauntlet.GauntletIO;
import forge.gamemodes.match.HostedMatch;
import forge.gui.GuiBase;
import forge.localinstance.properties.ForgeConstants;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class GauntletData {
    @XStreamOmitField
    private String name;
    private transient HostedMatch hostedMatch = null;
    private int completed;
    private String timestamp;
    private List<String> eventRecords = new ArrayList<String>();
    private List<String> eventNames = new ArrayList<String>();
    private Deck userDeck;
    private List<Deck> decks;
    private boolean isCommanderGauntlet = false;

    public GauntletData(boolean isCommander) {
        this.isCommanderGauntlet = isCommander;
    }

    public GauntletData() {
        this(false);
    }

    public boolean isCommanderGauntlet() {
        return this.isCommanderGauntlet;
    }

    public void setName(String name0) {
        this.name = name0;
    }

    public void rename(String newName) {
        File newpath = new File(ForgeConstants.GAUNTLET_DIR.userPrefLoc, newName + ".dat");
        File oldpath = new File(ForgeConstants.GAUNTLET_DIR.userPrefLoc, this.name + ".dat");
        oldpath.renameTo(newpath);
        this.name = newName;
        GauntletIO.saveGauntlet(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        if (this.name.startsWith("LOCKED_")) {
            return this.name.substring("LOCKED_".length());
        }
        return this.name;
    }

    public void stamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yy, H:m");
        this.timestamp = dateFormat.format(new Date());
    }

    public void reset() {
        this.completed = 0;
        this.stamp();
        this.eventRecords.clear();
        for (int i = 0; i < this.decks.size(); ++i) {
            this.eventRecords.add("");
        }
        GauntletIO.saveGauntlet(this);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setCompleted(int i0) {
        this.completed = i0;
    }

    public int getCompleted() {
        return this.completed;
    }

    public void setUserDeck(Deck d0) {
        this.userDeck = d0;
    }

    public Deck getUserDeck() {
        return this.userDeck;
    }

    public List<String> getDeckNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Deck d : this.decks) {
            names.add(d.getName());
        }
        return names;
    }

    public void setEventRecords(List<String> records0) {
        this.eventRecords = records0;
    }

    public List<String> getEventRecords() {
        return this.eventRecords;
    }

    public void setEventNames(List<String> names0) {
        this.eventNames = names0;
    }

    public List<String> getEventNames() {
        return this.eventNames;
    }

    public void setDecks(List<Deck> decks0) {
        this.decks = decks0;
    }

    public List<Deck> getDecks() {
        return this.decks;
    }

    public void startRound(List<RegisteredPlayer> players, RegisteredPlayer human) {
        this.hostedMatch = GuiBase.getInterface().hostMatch();
        this.hostedMatch.startMatch(this.isCommanderGauntlet ? GameType.CommanderGauntlet : GameType.Gauntlet, this.isCommanderGauntlet ? Collections.singleton(GameType.Commander) : null, players, human, GuiBase.getInterface().getNewGuiGame());
    }

    public void nextRound(List<RegisteredPlayer> players, RegisteredPlayer human) {
        if (this.hostedMatch == null) {
            throw new IllegalStateException("Cannot advance round when no match has been hosted.");
        }
        this.hostedMatch.endCurrentGame();
        this.startRound(players, human);
    }

    public String toString() {
        String str = this.getDisplayName();
        if (this.decks != null) {
            str = str + " (" + this.decks.size() + " opponents)";
        }
        return str;
    }
}

