/*
 * Decompiled with CFR 0.152.
 */
package forge.game.zone;

import forge.util.Localizer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public enum ZoneType {
    Hand(true, "lblHandZone"),
    Library(true, "lblLibraryZone"),
    Graveyard(false, "lblGraveyardZone"),
    Battlefield(false, "lblBattlefieldZone"),
    Exile(false, "lblExileZone"),
    Flashback(false, "lblFlashbackZone"),
    Command(false, "lblCommandZone"),
    Stack(false, "lblStackZone"),
    Sideboard(true, "lblSideboardZone"),
    Ante(false, "lblAnteZone"),
    Merged(false, "lblBattlefieldZone"),
    SchemeDeck(true, "lblSchemeDeckZone"),
    PlanarDeck(true, "lblPlanarDeckZone"),
    AttractionDeck(true, "lblAttractionDeckZone"),
    Junkyard(false, "lblJunkyardZone"),
    Subgame(true, "lblSubgameZone"),
    ExtraHand(true, "lblHandZone"),
    None(true, "lblNoneZone");

    public static final EnumSet<ZoneType> STATIC_ABILITIES_SOURCE_ZONES;
    public static final EnumSet<ZoneType> PART_OF_COMMAND_ZONE;
    public static final EnumSet<ZoneType> DECK_ZONES;
    private final boolean holdsHiddenInfo;
    private final String zoneName;

    private ZoneType(boolean holdsHidden, String name) {
        this.holdsHiddenInfo = holdsHidden;
        this.zoneName = Localizer.getInstance().getMessage(name, new Object[0]);
    }

    public static ZoneType smartValueOf(String value) {
        if (value == null) {
            return null;
        }
        if ("All".equals(value)) {
            return null;
        }
        String valToCompate = value.trim();
        for (ZoneType v : ZoneType.values()) {
            if (v.name().compareToIgnoreCase(valToCompate) != 0) continue;
            return v;
        }
        throw new IllegalArgumentException("No element named " + value + " in enum Zone");
    }

    public static List<ZoneType> listValueOf(String values) {
        ArrayList<ZoneType> result = new ArrayList<ZoneType>();
        for (String s2 : values.split("[, ]+")) {
            ZoneType zt = ZoneType.smartValueOf(s2);
            if (zt == null) continue;
            result.add(zt);
        }
        return result;
    }

    public boolean isHidden() {
        return this.holdsHiddenInfo;
    }

    public boolean isKnown() {
        return !this.holdsHiddenInfo;
    }

    public boolean isPartOfCommandZone() {
        return PART_OF_COMMAND_ZONE.contains((Object)this);
    }

    public boolean isDeck() {
        return DECK_ZONES.contains((Object)this);
    }

    public String getTranslatedName() {
        return this.zoneName;
    }

    public static boolean isHidden(String origin) {
        List<ZoneType> zone = ZoneType.listValueOf(origin);
        if (zone.isEmpty()) {
            return true;
        }
        for (ZoneType z : zone) {
            if (!z.isHidden()) continue;
            return true;
        }
        return false;
    }

    public static boolean isKnown(String origin) {
        return !ZoneType.isHidden(origin);
    }

    static {
        STATIC_ABILITIES_SOURCE_ZONES = EnumSet.of(Battlefield, Graveyard, Exile, Command, Stack);
        PART_OF_COMMAND_ZONE = EnumSet.of(Command, SchemeDeck, PlanarDeck, AttractionDeck, Junkyard);
        DECK_ZONES = EnumSet.of(Library, SchemeDeck, PlanarDeck, AttractionDeck);
    }
}

