/*
 * Decompiled with CFR 0.152.
 */
package forge.game.zone;

import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.player.Player;
import forge.game.zone.PlayerZone;
import forge.game.zone.ZoneType;

public class PlayerZoneBattlefield
extends PlayerZone {
    private static final long serialVersionUID = 5750837078903423978L;
    private boolean trigger = true;
    private CardCollection meldedCards = new CardCollection();

    public PlayerZoneBattlefield(ZoneType zone, Player player) {
        super(zone, player);
    }

    public final void addToMelded(Card c) {
        c.getZone().remove(c);
        this.meldedCards.add(c);
    }

    public final void removeFromMelded(Card c) {
        this.meldedCards.remove(c);
    }

    @Override
    public final void add(Card c, Integer position, Card latestState) {
        if (c == null) {
            throw new RuntimeException("PlayerZoneComesInto Play : add() object is null");
        }
        super.add(c, position, latestState);
        if (this.trigger) {
            c.setSickness(true);
        }
    }

    public final void setTriggers(boolean b) {
        this.trigger = b;
    }

    @Override
    public final CardCollectionView getCards(boolean filter) {
        CardCollectionView cards = super.getCards(false);
        if (!filter) {
            return cards;
        }
        boolean hasFilteredCard = false;
        for (Card c : cards) {
            if (!c.isPhasedOut()) continue;
            hasFilteredCard = true;
            break;
        }
        if (hasFilteredCard) {
            CardCollection filteredCollection = new CardCollection();
            for (Card c : cards) {
                if (c.isPhasedOut()) continue;
                filteredCollection.add(c);
            }
            cards = filteredCollection;
        }
        return cards;
    }
}

