/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.TreeBasedTable;
import forge.card.mana.ManaCost;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.ability.ApiType;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardDamageMap;
import forge.game.card.CardState;
import forge.game.card.CardZoneTable;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.spellability.Ability;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.AlternativeCost;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityRestriction;
import forge.game.spellability.TargetChoices;
import forge.game.spellability.TargetRestrictions;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WrappedAbility
extends Ability {
    static Set<ApiType> noTimestampCheck = ImmutableSet.of(ApiType.Abandon, ApiType.AddPhase, ApiType.AddTurn, ApiType.Amass, ApiType.Ascend, ApiType.BecomeMonarch, new ApiType[]{ApiType.Bond, ApiType.PutCounter, ApiType.MoveCounter, ApiType.MultiplyCounter, ApiType.MoveCounter, ApiType.RemoveCounter, ApiType.AddOrRemoveCounter, ApiType.MoveCounter, ApiType.Draw, ApiType.GainLife, ApiType.LoseLife, ApiType.ChangeZone, ApiType.Destroy, ApiType.Token, ApiType.SetState, ApiType.Play, ApiType.SacrificeAll, ApiType.Pump, ApiType.DealDamage, ApiType.Regenerate, ApiType.Regeneration, ApiType.DelayedTrigger});
    private final SpellAbility sa;
    private Player decider;
    boolean mandatory = false;

    public WrappedAbility(Trigger regtrig0, SpellAbility sa0, Player decider0) {
        super(sa0.getHostCard(), ManaCost.ZERO);
        this.setTrigger(regtrig0);
        this.sa = sa0;
        this.sa.setTrigger(regtrig0);
        this.decider = decider0;
    }

    public SpellAbility getWrappedAbility() {
        return this.sa;
    }

    @Override
    public boolean isWrapper() {
        return true;
    }

    public Player getDecider() {
        return this.decider;
    }

    @Override
    public String getParam(String key) {
        return this.sa.getParam(key);
    }

    @Override
    public boolean hasParam(String key) {
        return this.sa.hasParam(key);
    }

    @Override
    public String getParamOrDefault(String key, String defaultValue) {
        return this.sa.getParamOrDefault(key, defaultValue);
    }

    @Override
    public ApiType getApi() {
        return this.sa.getApi();
    }

    @Override
    public void setPaidHash(TreeBasedTable<String, Boolean, CardCollection> hash) {
        this.sa.setPaidHash(hash);
    }

    @Override
    public TreeBasedTable<String, Boolean, CardCollection> getPaidHash() {
        return this.sa.getPaidHash();
    }

    @Override
    public CardCollection getPaidList(String str, boolean intrinsic) {
        return this.sa.getPaidList(str, intrinsic);
    }

    @Override
    public void addCostToHashList(Card c, String str, boolean intrinsic) {
        this.sa.addCostToHashList(c, str, intrinsic);
    }

    @Override
    public void resetPaidHash() {
        this.sa.resetPaidHash();
    }

    @Override
    public Map<AbilityKey, Object> getTriggeringObjects() {
        return this.sa.getTriggeringObjects();
    }

    @Override
    public void setTriggeringObjects(Map<AbilityKey, Object> triggeredObjects) {
        this.sa.setTriggeringObjects(triggeredObjects);
    }

    @Override
    public void setTriggeringObject(AbilityKey type, Object o) {
        this.sa.setTriggeringObject(type, o);
    }

    @Override
    public Object getTriggeringObject(AbilityKey type) {
        return this.sa.getTriggeringObject(type);
    }

    @Override
    public boolean hasTriggeringObject(AbilityKey type) {
        return this.sa.hasTriggeringObject(type);
    }

    @Override
    public void resetTriggeringObjects() {
        this.sa.resetTriggeringObjects();
    }

    @Override
    public List<Object> getTriggerRemembered() {
        return this.sa.getTriggerRemembered();
    }

    @Override
    public void resetTriggerRemembered() {
        this.sa.resetTriggerRemembered();
    }

    @Override
    public void setTriggerRemembered(List<Object> list) {
        this.sa.setTriggerRemembered(list);
    }

    @Override
    public boolean canPlay() {
        return this.sa.canPlay();
    }

    @Override
    public SpellAbility copy() {
        return this.sa.copy();
    }

    @Override
    public SpellAbilityRestriction getRestrictions() {
        return this.sa.getRestrictions();
    }

    @Override
    public SpellAbility getSATargetingCard() {
        return this.sa.getSATargetingCard();
    }

    @Override
    public String yieldKey() {
        if (this.getTrigger() != null) {
            if (this.getHostCard() != null) {
                return this.getHostCard().toString() + ": " + this.getTrigger().toString();
            }
            return this.getTrigger().toString();
        }
        return super.yieldKey();
    }

    @Override
    public String toUnsuppressedString() {
        String card;
        String desc = this.getStackDescription();
        if (!desc.contains(card = this.getHostCard().toString()) && desc.contains(" this ")) {
            return card + ": " + desc;
        }
        return desc;
    }

    @Override
    public String getStackDescription() {
        String important;
        Trigger regtrig = this.getTrigger();
        if (regtrig == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(regtrig.replaceAbilityText(regtrig.toString(true), this, true));
        List<TargetChoices> allTargets = this.sa.getAllTargetChoices();
        if (!allTargets.isEmpty() && !ApiType.Charm.equals((Object)this.sa.getApi())) {
            sb.append(" (Targeting: ");
            sb.append(allTargets);
            sb.append(")");
        }
        if (!(important = regtrig.getImportantStackObjects(this)).isEmpty()) {
            sb.append(" [");
            sb.append(important);
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public void setStackDescription(String s2) {
        this.sa.setStackDescription(s2);
    }

    @Override
    public TargetRestrictions getTargetRestrictions() {
        return this.sa.getTargetRestrictions();
    }

    @Override
    public void setTargetRestrictions(TargetRestrictions tgt) {
        this.sa.setTargetRestrictions(tgt);
    }

    @Override
    public Card getTargetCard() {
        return this.sa.getTargetCard();
    }

    @Override
    public TargetChoices getTargets() {
        return this.sa.getTargets();
    }

    @Override
    public void setTargets(TargetChoices targets) {
        this.sa.setTargets(targets);
    }

    @Override
    public boolean isAbility() {
        return this.sa.isAbility();
    }

    @Override
    public boolean isBuyback() {
        return this.sa.isBuyback();
    }

    @Override
    public boolean isCycling() {
        return this.sa.isCycling();
    }

    @Override
    public boolean isChapter() {
        return this.sa.isChapter();
    }

    @Override
    public Integer getChapter() {
        return this.sa.getChapter();
    }

    @Override
    public boolean isFlashback() {
        return this.sa.isFlashback();
    }

    @Override
    public boolean isSpell() {
        return this.sa.isSpell();
    }

    @Override
    public String getSVar(String name) {
        return this.sa.getSVar(name);
    }

    @Override
    public Integer getSVarInt(String name) {
        return this.sa.getSVarInt(name);
    }

    @Override
    public Map<String, String> getSVars() {
        return this.sa.getSVars();
    }

    @Override
    public void resetOnceResolved() {
    }

    @Override
    public Player getActivatingPlayer() {
        return this.sa.getActivatingPlayer();
    }

    @Override
    public void setActivatingPlayer(Player player) {
        this.sa.setActivatingPlayer(player);
    }

    @Override
    public boolean setActivatingPlayer(Player player, boolean lki) {
        return this.sa.setActivatingPlayer(player, lki);
    }

    @Override
    public String getDescription() {
        return this.sa.getDescription();
    }

    @Override
    public void setDescription(String s2) {
        this.sa.setDescription(s2);
    }

    @Override
    public void setPayCosts(Cost abCost) {
        this.sa.setPayCosts(abCost);
    }

    @Override
    public void setRestrictions(SpellAbilityRestriction restrict) {
        this.sa.setRestrictions(restrict);
    }

    @Override
    public void setHostCard(Card c) {
        this.sa.setHostCard(c);
    }

    @Override
    public AbilitySub getSubAbility() {
        return this.sa.getSubAbility();
    }

    @Override
    public void setSubAbility(AbilitySub subAbility) {
        this.sa.setSubAbility(subAbility);
    }

    @Override
    public void setTargetCard(Card card) {
        this.sa.setTargetCard(card);
    }

    @Override
    public void setSourceTrigger(int id) {
        this.sa.setSourceTrigger(id);
    }

    @Override
    public int getSourceTrigger() {
        return this.sa.getSourceTrigger();
    }

    @Override
    public void setOptionalTrigger(boolean b) {
        this.sa.setOptionalTrigger(b);
    }

    @Override
    public boolean isOptionalTrigger() {
        return this.sa.isOptionalTrigger();
    }

    @Override
    public boolean usesTargeting() {
        return this.sa.usesTargeting();
    }

    @Override
    public boolean hasAdditionalAbility(String ability) {
        return this.sa.hasAdditionalAbility(ability);
    }

    @Override
    public SpellAbility getAdditionalAbility(String ability) {
        return this.sa.getAdditionalAbility(ability);
    }

    @Override
    public Map<String, List<AbilitySub>> getAdditionalAbilityLists() {
        return this.sa.getAdditionalAbilityLists();
    }

    @Override
    public List<AbilitySub> getAdditionalAbilityList(String name) {
        return this.sa.getAdditionalAbilityList(name);
    }

    @Override
    public void setAdditionalAbilityList(String name, List<AbilitySub> list) {
        this.sa.setAdditionalAbilityList(name, list);
    }

    @Override
    public void resetTargets() {
        this.sa.resetTargets();
    }

    @Override
    public void resolve() {
        Game game = this.getActivatingPlayer().getGame();
        Trigger regtrig = this.getTrigger();
        if (!TriggerType.Always.equals((Object)regtrig.getMode()) && !regtrig.hasParam("NoResolvingCheck")) {
            if (!regtrig.requirementsCheck(game)) {
                return;
            }
            if (!regtrig.meetsRequirementsOnTriggeredObjects(game, this.getTriggeringObjects())) {
                return;
            }
        }
        if (!regtrig.checkResolvedLimit(this.getActivatingPlayer())) {
            return;
        }
        if (regtrig.hasParam("ResolvingCheck")) {
            HashMap<String, String> recheck = Maps.newHashMap();
            String key = regtrig.getParam("ResolvingCheck");
            recheck.put(key, regtrig.getParam(key));
            if (!this.meetsCommonRequirements(recheck)) {
                return;
            }
        }
        if (this.decider != null) {
            if (!this.decider.isInGame()) {
                this.decider = SpellAbilityEffect.getNewChooser(this.sa, this.getActivatingPlayer(), this.decider);
            }
            if (!this.decider.getController().confirmTrigger(this)) {
                return;
            }
        }
        this.timestampCheck();
        this.getActivatingPlayer().getController().playSpellAbilityNoStack(this.sa, false);
    }

    protected void timestampCheck() {
        Game game = this.sa.getActivatingPlayer().getGame();
        if (noTimestampCheck.contains((Object)this.sa.getApi())) {
            return;
        }
        EnumMap<AbilityKey, Object> triggerMap = AbilityKey.newMap(this.sa.getTriggeringObjects());
        for (Map.Entry ev : triggerMap.entrySet()) {
            if (!(ev.getValue() instanceof Card)) continue;
            Card card = (Card)ev.getValue();
            Card current = game.getCardState(card);
            if (!card.isInPlay() || !current.isInPlay() || current.equalsWithGameTimestamp(card)) continue;
            this.sa.getTriggeringObjects().remove(ev.getKey());
        }
    }

    @Override
    public CardDamageMap getDamageMap() {
        return this.sa.getDamageMap();
    }

    @Override
    public CardDamageMap getPreventMap() {
        return this.sa.getPreventMap();
    }

    @Override
    public GameEntityCounterTable getCounterTable() {
        return this.sa.getCounterTable();
    }

    @Override
    public CardZoneTable getChangeZoneTable() {
        return this.sa.getChangeZoneTable();
    }

    @Override
    public void setDamageMap(CardDamageMap map) {
        this.sa.setDamageMap(map);
    }

    @Override
    public void setPreventMap(CardDamageMap map) {
        this.sa.setPreventMap(map);
    }

    @Override
    public void setCounterTable(GameEntityCounterTable table) {
        this.sa.setCounterTable(table);
    }

    @Override
    public void setChangeZoneTable(CardZoneTable table) {
        this.sa.setChangeZoneTable(table);
    }

    @Override
    public boolean isAlternativeCost(AlternativeCost ac) {
        return this.sa.isAlternativeCost(ac);
    }

    @Override
    public AlternativeCost getAlternativeCost() {
        return this.sa.getAlternativeCost();
    }

    @Override
    public void setAlternativeCost(AlternativeCost ac) {
        this.sa.setAlternativeCost(ac);
    }

    @Override
    public Integer getXManaCostPaid() {
        return this.sa.getXManaCostPaid();
    }

    @Override
    public void setXManaCostPaid(Integer n) {
        this.sa.setXManaCostPaid(n);
    }

    @Override
    public CardState getCardState() {
        return this.sa.getCardState();
    }

    @Override
    public void setCardState(CardState state) {
        this.sa.setCardState(state);
    }

    @Override
    public List<AbilitySub> getChosenList() {
        return this.sa.getChosenList();
    }

    @Override
    public void setChosenList(List<AbilitySub> choices) {
        this.sa.setChosenList(choices);
    }

    @Override
    public boolean isIntrinsic() {
        return this.sa.isIntrinsic();
    }

    @Override
    public boolean isKeyword(Keyword kw) {
        return this.sa.isKeyword(kw);
    }
}

