/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerScry
extends Trigger {
    public TriggerScry(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        Integer numBottom;
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Player))) {
            return false;
        }
        return !this.hasParam("ToBottom") || (numBottom = (Integer)runParams.get((Object)AbilityKey.ScryBottom)) > 0;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Player, AbilityKey.ScryNum, AbilityKey.ScryBottom);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblScryer", new Object[0])).append(": ");
        sb.append(sa.getTriggeringObject(AbilityKey.Player)).append(", ");
        sb.append(sa.getTriggeringObject(AbilityKey.ScryNum));
        return sb.toString();
    }
}

