/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Expressions;
import forge.util.Localizer;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TriggerRolledDie
extends Trigger {
    public TriggerRolledDie(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Player))) {
            return false;
        }
        if (this.hasParam("RolledToVisitAttractions") && !((Boolean)runParams.getOrDefault((Object)AbilityKey.RolledToVisitAttractions, false)).booleanValue()) {
            return false;
        }
        if (this.hasParam("ValidResult")) {
            String[] params = this.getParam("ValidResult").split(",");
            int result = (Integer)runParams.get((Object)AbilityKey.Result);
            if (this.hasParam("Natural")) {
                result -= ((Integer)runParams.get((Object)AbilityKey.Modifier)).intValue();
            }
            for (String param : params) {
                int rightSide;
                String comp;
                int sides;
                if (!(StringUtils.isNumeric(param) ? param.equals("" + result) : (param.equals("Highest") ? result == (sides = ((Integer)runParams.get((Object)AbilityKey.Sides)).intValue()) : Expressions.compare(result, comp = param.substring(0, 2), rightSide = Integer.parseInt(param.substring(2)))))) continue;
                return true;
            }
            return false;
        }
        if (this.hasParam("ValidSides")) {
            int validSides = Integer.parseInt(this.getParam("ValidSides"));
            int sides = (Integer)runParams.get((Object)AbilityKey.Sides);
            if (sides == validSides) {
                return true;
            }
        }
        return !this.hasParam("Number") || (Integer)runParams.get((Object)AbilityKey.Number) == Integer.parseInt(this.getParam("Number"));
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Result, AbilityKey.Player);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        return Localizer.getInstance().getMessage("lblPlayer", new Object[0]) + ": " + sa.getTriggeringObject(AbilityKey.Player) + ", " + Localizer.getInstance().getMessage("lblResultIs", sa.getTriggeringObject(AbilityKey.Result));
    }
}

