/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.card.MagicColor;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.Map;

public class TriggerManaAdded
extends Trigger {
    public TriggerManaAdded(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.Card))) {
            return false;
        }
        if (!this.matchesValidParam("ValidSA", runParams.get((Object)AbilityKey.AbilityMana))) {
            return false;
        }
        if (!this.matchesValidParam("Player", runParams.get((Object)AbilityKey.Player))) {
            return false;
        }
        if (this.hasParam("Produced")) {
            Object prod = runParams.get((Object)AbilityKey.Produced);
            if (!(prod instanceof String)) {
                return false;
            }
            String produced = (String)prod;
            if ("ChosenColor".equals(this.getParam("Produced")) ? !this.getHostCard().hasChosenColor() || !produced.contains(MagicColor.toShortString(this.getHostCard().getChosenColor())) : !produced.contains(MagicColor.toShortString(this.getParam("Produced")))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Card, AbilityKey.Player, AbilityKey.Produced);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        return Localizer.getInstance().getMessage("lblProduced", new Object[0]) + ": " + TextUtil.toManaString(sa.getTriggeringObject(AbilityKey.Produced).toString());
    }
}

