/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerExplores
extends Trigger {
    public TriggerExplores(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Card))) {
            return false;
        }
        return this.matchesValidParam("ValidExplored", runParams.get((Object)AbilityKey.Explored));
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObject(AbilityKey.Explorer, runParams.get((Object)AbilityKey.Card));
        if (runParams.containsKey((Object)AbilityKey.Explored)) {
            sa.setTriggeringObjectsFrom(runParams, AbilityKey.Explored);
        }
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblExplorer", new Object[0])).append(": ");
        sb.append(sa.getTriggeringObject(AbilityKey.Explorer));
        if (sa.hasTriggeringObject(AbilityKey.Explored)) {
            sb.append(", ").append(Localizer.getInstance().getMessage("lblExplored", new Object[0])).append(": ");
            sb.append(sa.getTriggeringObject(AbilityKey.Explored));
        }
        return sb.toString();
    }
}

