/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCopyService;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerDamageDoneOnceByController
extends Trigger {
    public TriggerDamageDoneOnceByController(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean performTest(Map<AbilityKey, Object> runParams) {
        if (this.hasParam("CombatDamage") && this.getParam("CombatDamage").equals("True") != ((Boolean)runParams.get((Object)AbilityKey.IsCombatDamage)).booleanValue()) {
            return false;
        }
        if (!this.matchesValidParam("ValidTarget", runParams.get((Object)AbilityKey.DamageTarget))) {
            return false;
        }
        return this.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.DamageSource));
    }

    @Override
    public void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        Object target = runParams.get((Object)AbilityKey.DamageTarget);
        if (target instanceof Card) {
            target = CardCopyService.getLKICopy((Card)runParams.get((Object)AbilityKey.DamageTarget));
        }
        sa.setTriggeringObject(AbilityKey.Target, target);
        sa.setTriggeringObject(AbilityKey.Source, runParams.get((Object)AbilityKey.DamageSource));
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        if (sa.getTriggeringObject(AbilityKey.Target) != null) {
            sb.append(Localizer.getInstance().getMessage("lblDamaged", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Target)).append(", ");
        }
        sb.append(Localizer.getInstance().getMessage("lblDamageSource", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Source));
        return sb.toString();
    }
}

