/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCopyService;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Expressions;
import forge.util.Localizer;
import java.util.Map;

public class TriggerDamageDone
extends Trigger {
    public TriggerDamageDone(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        int operand;
        String operator;
        String fullParam;
        if (!this.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.DamageSource))) {
            return false;
        }
        if (!this.matchesValidParam("ValidTarget", runParams.get((Object)AbilityKey.DamageTarget))) {
            return false;
        }
        if (!this.matchesValidParam("ValidCause", runParams.get((Object)AbilityKey.Cause))) {
            return false;
        }
        if (this.hasParam("CombatDamage") && this.getParam("CombatDamage").equalsIgnoreCase("True") != ((Boolean)runParams.get((Object)AbilityKey.IsCombatDamage)).booleanValue()) {
            return false;
        }
        if (this.hasParam("TargetRelativeToCause")) {
            SpellAbility cause = (SpellAbility)runParams.get((Object)AbilityKey.Cause);
            if (cause == null) {
                return false;
            }
            if (!cause.matchesValidParam(this.getParam("TargetRelativeToCause"), runParams.get((Object)AbilityKey.DamageTarget))) {
                return false;
            }
        }
        if (!this.matchesValidParam("TargetRelativeToSource", runParams.get((Object)AbilityKey.DamageTarget), (Card)runParams.get((Object)AbilityKey.DamageSource))) {
            return false;
        }
        if (this.hasParam("DamageAmount")) {
            fullParam = this.getParam("DamageAmount");
            operator = fullParam.substring(0, 2);
            if (fullParam.substring(2).equals("TargetToughness")) {
                Card target = (Card)runParams.get((Object)AbilityKey.DamageTarget);
                operand = target.getNetToughness();
            } else {
                operand = Integer.parseInt(fullParam.substring(2));
            }
            int actualAmount = (Integer)runParams.get((Object)AbilityKey.DamageAmount);
            if (!Expressions.compare(actualAmount, operator, operand)) {
                return false;
            }
        }
        if (this.hasParam("DamageToTargetThisTurnCondition")) {
            fullParam = this.getParam("DamageToTargetThisTurnCondition");
            operator = fullParam.substring(0, 2);
            operand = Integer.parseInt(fullParam.substring(2));
            Object target = runParams.get((Object)AbilityKey.DamageTarget);
            Card source = (Card)runParams.get((Object)AbilityKey.DamageSource);
            if (target instanceof Player) {
                Player trigTgt = (Player)target;
                if (!Expressions.compare(trigTgt.getAssignedDamage(null, source), operator, operand)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObject(AbilityKey.Source, CardCopyService.getLKICopy((Card)runParams.get((Object)AbilityKey.DamageSource)));
        sa.setTriggeringObject(AbilityKey.Target, runParams.get((Object)AbilityKey.DamageTarget));
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Cause, AbilityKey.DamageAmount, AbilityKey.DefendingPlayer);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblDamageSource", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Source)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblDamaged", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Target)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblAmount", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.DamageAmount));
        return sb.toString();
    }
}

