/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.Sets;
import forge.game.GameEntity;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TriggerDamageDealtOnce
extends Trigger {
    public TriggerDamageDealtOnce(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        Map damageMap;
        if (this.hasParam("CombatDamage") && this.getParam("CombatDamage").equals("True") != ((Boolean)runParams.get((Object)AbilityKey.IsCombatDamage)).booleanValue()) {
            return false;
        }
        if (this.hasParam("ValidTarget") && this.getDamageAmount(damageMap = (Map)runParams.get((Object)AbilityKey.DamageMap)) <= 0) {
            return false;
        }
        return this.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.DamageSource));
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        Map damageMap = (Map)runParams.get((Object)AbilityKey.DamageMap);
        sa.setTriggeringObject(AbilityKey.Source, runParams.get((Object)AbilityKey.DamageSource));
        sa.setTriggeringObject(AbilityKey.Targets, this.getDamageTargets(damageMap));
        sa.setTriggeringObject(AbilityKey.DamageAmount, this.getDamageAmount(damageMap));
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblDamageSource", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Source)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblDamaged", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Targets)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblAmount", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.DamageAmount));
        return sb.toString();
    }

    public int getDamageAmount(Map<GameEntity, Integer> damageMap) {
        int result = 0;
        for (Map.Entry<GameEntity, Integer> e : damageMap.entrySet()) {
            if (!this.matchesValidParam("ValidTarget", e.getKey())) continue;
            result += e.getValue().intValue();
        }
        return result;
    }

    public Set<GameEntity> getDamageTargets(Map<GameEntity, Integer> damageMap) {
        if (!this.hasParam("ValidTarget")) {
            return Sets.newHashSet(damageMap.keySet());
        }
        HashSet<GameEntity> result = Sets.newHashSet();
        for (GameEntity e : damageMap.keySet()) {
            if (!this.matchesValidParam("ValidTarget", e)) continue;
            result.add(e);
        }
        return result;
    }
}

