/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CounterType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerCounterRemovedOnce
extends Trigger {
    public TriggerCounterRemovedOnce(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        int remaining;
        String type;
        CounterType removedType = (CounterType)runParams.get((Object)AbilityKey.CounterType);
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Card))) {
            return false;
        }
        if (this.hasParam("CounterType") && !(type = this.getParam("CounterType")).equals(removedType.toString())) {
            return false;
        }
        return !this.hasParam("Remaining") || (remaining = Integer.parseInt(this.getParam("Remaining"))) == (Integer)runParams.get((Object)AbilityKey.NewCounterAmount);
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Card);
        sa.setTriggeringObject(AbilityKey.Amount, runParams.get((Object)AbilityKey.CounterAmount));
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblRemovedFrom", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Card));
        sb.append(" ").append(Localizer.getInstance().getMessage("lblAmount", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Amount));
        return sb.toString();
    }
}

