/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.base.Functions;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Aggregates;
import forge.util.Localizer;
import java.util.Map;

public class TriggerCounterPlayerAddedAll
extends Trigger {
    public TriggerCounterPlayerAddedAll(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean performTest(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.Source))) {
            return false;
        }
        if (!this.matchesValidParam("ValidObject", runParams.get((Object)AbilityKey.Object))) {
            return false;
        }
        return !this.hasParam("ValidObjectToSource") || this.matchesValid(runParams.get((Object)AbilityKey.Object), this.getParam("ValidObjectToSource").split(","), this.getHostCard(), (Player)runParams.get((Object)AbilityKey.Source));
    }

    @Override
    public void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Source, AbilityKey.Object, AbilityKey.CounterMap);
        sa.setTriggeringObject(AbilityKey.Amount, Aggregates.sum(((Map)runParams.get((Object)AbilityKey.CounterMap)).values(), Functions.identity()));
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblAddedOnce", new Object[0])).append(": ");
        sb.append(sa.getTriggeringObject(AbilityKey.Source)).append(": ");
        sb.append(sa.getTriggeringObject(AbilityKey.Object));
        return sb.toString();
    }
}

