/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CounterType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerCounterAddedOnce
extends Trigger {
    public TriggerCounterAddedOnce(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        if (this.hasParam("CounterType")) {
            CounterType addedType = (CounterType)runParams.get((Object)AbilityKey.CounterType);
            String type = this.getParam("CounterType");
            if (!type.equals(addedType.toString())) {
                return false;
            }
        }
        if (!this.matchesValidParam("ValidEntity", runParams.get((Object)AbilityKey.Card)) && !this.matchesValidParam("ValidEntity", runParams.get((Object)AbilityKey.Player))) {
            return false;
        }
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Card))) {
            return false;
        }
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Player))) {
            return false;
        }
        if (!this.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.Source))) {
            return false;
        }
        return !this.hasParam("FirstTime") || (Boolean)runParams.get((Object)AbilityKey.FirstTime) != false;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Card, AbilityKey.Player);
        sa.setTriggeringObject(AbilityKey.Amount, runParams.get((Object)AbilityKey.CounterAmount));
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblAddedOnce", new Object[0])).append(": ");
        if (sa.hasTriggeringObject(AbilityKey.Card)) {
            sb.append(sa.getTriggeringObject(AbilityKey.Card));
        }
        if (sa.hasTriggeringObject(AbilityKey.Player)) {
            sb.append(sa.getTriggeringObject(AbilityKey.Player));
        }
        sb.append(" ").append(Localizer.getInstance().getMessage("lblAmount", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Amount));
        return sb.toString();
    }
}

