/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CounterType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Expressions;
import forge.util.Localizer;
import java.util.Map;

public class TriggerCounterAdded
extends Trigger {
    public TriggerCounterAdded(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        String type;
        CounterType addedType = (CounterType)runParams.get((Object)AbilityKey.CounterType);
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Card))) {
            return false;
        }
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Player))) {
            return false;
        }
        if (!this.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.Source))) {
            return false;
        }
        if (this.hasParam("CounterType") && !(type = this.getParam("CounterType")).equals(addedType.toString())) {
            return false;
        }
        if (this.hasParam("CounterAmount") && runParams.containsKey((Object)AbilityKey.CounterAmount)) {
            String fullParam = this.getParam("CounterAmount");
            String operator = fullParam.substring(0, 2);
            int operand = Integer.parseInt(fullParam.substring(2));
            int actualAmount = (Integer)runParams.get((Object)AbilityKey.CounterAmount);
            if (!Expressions.compare(actualAmount, operator, operand)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Card, AbilityKey.Player);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblAddedOnce", new Object[0])).append(": ");
        if (sa.hasTriggeringObject(AbilityKey.Card)) {
            sb.append(sa.getTriggeringObject(AbilityKey.Card));
        }
        if (sa.hasTriggeringObject(AbilityKey.Player)) {
            sb.append(sa.getTriggeringObject(AbilityKey.Player));
        }
        return sb.toString();
    }
}

