/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerBecomesTargetOnce
extends Trigger {
    public TriggerBecomesTargetOnce(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.SourceSA))) {
            return false;
        }
        if (!this.matchesValidParam("ValidTarget", runParams.get((Object)AbilityKey.Targets))) {
            return false;
        }
        return this.matchesValidParam("ValidCause", runParams.get((Object)AbilityKey.Cause));
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.SourceSA, AbilityKey.Targets);
        sa.setTriggeringObject(AbilityKey.Source, ((SpellAbility)runParams.get((Object)AbilityKey.SourceSA)).getHostCard());
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblSource", new Object[0])).append(": ").append(((SpellAbility)sa.getTriggeringObject(AbilityKey.SourceSA)).getHostCard()).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblTargets", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Targets));
        return sb.toString();
    }
}

