/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerBecomesTarget
extends Trigger {
    public TriggerBecomesTarget(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        if (this.hasParam("ValidSource")) {
            SpellAbility source = (SpellAbility)runParams.get((Object)AbilityKey.SourceSA);
            if (source == null) {
                return false;
            }
            String[] valid = this.getParam("ValidSource").split(",");
            if (!this.matchesValid(source, valid) && !this.matchesValid(source.getHostCard(), valid)) {
                return false;
            }
        }
        if (!this.matchesValidParam("ValidTarget", runParams.get((Object)AbilityKey.Target))) {
            return false;
        }
        if (this.hasParam("FirstTime") && !runParams.containsKey((Object)AbilityKey.FirstTime)) {
            return false;
        }
        return !this.hasParam("Valiant") || runParams.containsKey((Object)AbilityKey.Valiant);
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObject(AbilityKey.Source, ((SpellAbility)runParams.get((Object)AbilityKey.SourceSA)).getHostCard());
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.SourceSA, AbilityKey.Target);
        sa.setTriggeringObject(AbilityKey.StackInstance, sa.getHostCard().getGame().getStack().getInstanceMatchingSpellAbilityID((SpellAbility)runParams.get((Object)AbilityKey.SourceSA)));
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblSource", new Object[0])).append(": ").append(((SpellAbility)sa.getTriggeringObject(AbilityKey.SourceSA)).getHostCard()).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblTarget", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Target));
        return sb.toString();
    }
}

