/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerBecomesCrewed
extends Trigger {
    public TriggerBecomesCrewed(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean performTest(Map<AbilityKey, Object> runParams) {
        Card v;
        if (!this.matchesValidParam("ValidVehicle", runParams.get((Object)AbilityKey.Vehicle))) {
            return false;
        }
        if (!this.matchesValidParam("ValidCrew", runParams.get((Object)AbilityKey.Crew))) {
            return false;
        }
        if (this.hasParam("FirstTimeCrewed") && (v = (Card)runParams.get((Object)AbilityKey.Vehicle)).getTimesCrewedThisTurn() != 1) {
            return false;
        }
        if (this.hasParam("ValidCrewAmount")) {
            v = (Card)runParams.get((Object)AbilityKey.Vehicle);
            CardCollection crews = (CardCollection)runParams.get((Object)AbilityKey.Crew);
            if (crews == null) {
                return false;
            }
            int amount = AbilityUtils.calculateAmount(v, this.getParam("ValidCrewAmount"), null);
            if (amount != crews.size()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Vehicle, AbilityKey.Crew);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblVehicle", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Vehicle));
        sb.append("  ");
        sb.append(Localizer.getInstance().getMessage("lblCrew", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Crew));
        return sb.toString();
    }
}

