/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerAttackerBlockedByCreature
extends Trigger {
    public TriggerAttackerBlockedByCreature(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        String validBlocker;
        String validCard;
        Object a = runParams.get((Object)AbilityKey.Attacker);
        Object b = runParams.get((Object)AbilityKey.Blocker);
        if (!(a instanceof Card) || !(b instanceof Card)) {
            return false;
        }
        Card attacker = (Card)a;
        Card blocker = (Card)b;
        if (this.hasParam("ValidCard") && ((validCard = this.getParam("ValidCard")).equals("LessPowerThanBlocker") ? attacker.getNetPower() >= blocker.getNetPower() : !this.matchesValid(attacker, validCard.split(",")))) {
            return false;
        }
        return !this.hasParam("ValidBlocker") || !((validBlocker = this.getParam("ValidBlocker")).equals("LessPowerThanAttacker") ? blocker.getNetPower() >= attacker.getNetPower() : !this.matchesValid(blocker, validBlocker.split(",")));
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Attacker, AbilityKey.Blocker);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblAttacker", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Attacker)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblBlocker", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Blocker));
        return sb.toString();
    }
}

