/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerAttached
extends Trigger {
    public TriggerAttached(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.AttachSource))) {
            return false;
        }
        if (!this.matchesValidParam("ValidTarget", runParams.get((Object)AbilityKey.AttachTarget))) {
            return false;
        }
        return this.matchesValidParam("TargetRelativeToSource", runParams.get((Object)AbilityKey.AttachTarget), (Card)runParams.get((Object)AbilityKey.AttachSource));
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObject(AbilityKey.Source, runParams.get((Object)AbilityKey.AttachSource));
        sa.setTriggeringObject(AbilityKey.Target, runParams.get((Object)AbilityKey.AttachTarget));
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblAttachee", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Target));
        return sb.toString();
    }
}

