/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardZoneTable;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TriggerAbilityTriggered
extends Trigger {
    public TriggerAbilityTriggered(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        List<String> destinations;
        List<String> validDestinations;
        String mode;
        List<String> validModes;
        SpellAbility spellAbility = (SpellAbility)runParams.get((Object)AbilityKey.SpellAbility);
        if (spellAbility == null) {
            System.out.println("TriggerAbilityTriggered performTest encountered spellAbility == null. runParams2 = " + runParams);
            return false;
        }
        Card source = spellAbility.getHostCard();
        Iterable causes = (Iterable)runParams.get((Object)AbilityKey.Cause);
        if (this.hasParam("ValidMode") && !(validModes = Arrays.asList(this.getParam("ValidMode").split(","))).contains(mode = (String)runParams.get((Object)AbilityKey.Mode))) {
            return false;
        }
        if (this.hasParam("ValidDestination") && Collections.disjoint(validDestinations = Arrays.asList(this.getParam("ValidDestination").split(",")), destinations = Arrays.asList(((String)runParams.get((Object)AbilityKey.Destination)).split(",")))) {
            return false;
        }
        if (!this.matchesValidParam("ValidSpellAbility", spellAbility)) {
            return false;
        }
        if (!this.matchesValidParam("ValidSource", source)) {
            return false;
        }
        if (!this.matchesValidParam("ValidCause", causes)) {
            return false;
        }
        return !this.hasParam("TriggeredOwnAbility") || !"True".equals(this.getParam("TriggeredOwnAbility")) || Iterables.contains(causes, source);
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        SpellAbility triggeredSA = (SpellAbility)runParams.get((Object)AbilityKey.SpellAbility);
        sa.setTriggeringObject(AbilityKey.Source, triggeredSA.getHostCard());
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.SpellAbility, AbilityKey.Cause);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblSpellAbility", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.SpellAbility));
        return sb.toString();
    }

    public static Map<AbilityKey, Object> getRunParams(Trigger regtrig, SpellAbility sa, Map<AbilityKey, Object> runParams) {
        EnumMap<AbilityKey, Object> newRunParams = AbilityKey.newMap();
        newRunParams.put(AbilityKey.Mode, regtrig.getMode().toString());
        if (regtrig.getMode() == TriggerType.ChangesZone) {
            newRunParams.put(AbilityKey.Destination, runParams.getOrDefault((Object)AbilityKey.Destination, ""));
            newRunParams.put(AbilityKey.Cause, ImmutableList.of(runParams.get((Object)AbilityKey.Card)));
        } else if (regtrig.getMode() == TriggerType.ChangesZoneAll) {
            CardZoneTable table = (CardZoneTable)runParams.get((Object)AbilityKey.Cards);
            HashSet<String> destinations = new HashSet<String>();
            for (ZoneType dest : ZoneType.values()) {
                if (!table.containsColumn((Object)dest) || table.column(dest).isEmpty()) continue;
                destinations.add(dest.toString());
            }
            newRunParams.put(AbilityKey.Destination, (Object)TextUtil.join(destinations, ","));
            newRunParams.put(AbilityKey.Cause, table.allCards());
        }
        newRunParams.put(AbilityKey.SpellAbility, sa);
        return newRunParams;
    }
}

