/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.card.CardView;
import forge.game.card.IHasCardView;
import forge.game.staticability.StaticAbility;
import forge.trackable.TrackableObject;
import forge.trackable.TrackableProperty;
import forge.trackable.Tracker;

public class StaticAbilityView
extends TrackableObject
implements IHasCardView {
    private static final long serialVersionUID = 1L;

    StaticAbilityView(StaticAbility st) {
        this(st, st.getHostCard() == null || st.getHostCard().getGame() == null ? null : st.getHostCard().getGame().getTracker());
    }

    StaticAbilityView(StaticAbility st, Tracker tracker) {
        super(st.getId(), tracker);
        this.updateHostCard(st);
        this.updateDescription(st);
    }

    @Override
    public CardView getCardView() {
        return this.getHostCard();
    }

    public CardView getHostCard() {
        return (CardView)this.get(TrackableProperty.ST_HostCard);
    }

    void updateHostCard(StaticAbility st) {
        this.set(TrackableProperty.ST_HostCard, CardView.get(st.getHostCard()));
    }

    public String toString() {
        return this.getDescription();
    }

    public String getDescription() {
        return (String)this.get(TrackableProperty.ST_Description);
    }

    void updateDescription(StaticAbility st) {
        this.set(TrackableProperty.ST_Description, st.toString());
    }
}

