/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilitySurveilNum {
    static String MODE = "SurveilNum";

    public static int surveilNumMod(Player p) {
        Game game = p.getGame();
        int mod = 0;
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE)) continue;
                mod += StaticAbilitySurveilNum.getSurveilMod(stAb, p);
            }
        }
        return mod;
    }

    public static int getSurveilMod(StaticAbility stAb, Player p) {
        if (!stAb.matchesValidParam("ValidPlayer", p)) {
            return 0;
        }
        if (stAb.hasParam("Optional") && !p.getController().confirmStaticApplication(stAb.getHostCard(), null, stAb.toString() + "?", null)) {
            return 0;
        }
        return Integer.parseInt(stAb.getParam("Num"));
    }
}

