/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import forge.game.Game;
import forge.game.GameObjectPredicates;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardDamageMap;
import forge.game.card.CardZoneTable;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class StaticAbilityPanharmonicon {
    static String MODE = "Panharmonicon";

    public static int handlePanharmonicon(Game game, Trigger t2, Map<AbilityKey, Object> runParams) {
        int n = 0;
        if (t2.isStatic() && t2.getMode() != TriggerType.TapsForMana && t2.getMode() != TriggerType.ManaAdded) {
            return n;
        }
        if (t2.getSpawningAbility() != null) {
            return n;
        }
        Iterable cardList = null;
        if (t2.getMode() == TriggerType.Exploited || t2.getMode() == TriggerType.Sacrificed || t2.getMode() == TriggerType.Destroyed || (t2.getMode() == TriggerType.ChangesZone || t2.getMode() == TriggerType.ChangesZoneAll) && "Battlefield".equals(t2.getParam("Origin"))) {
            if (runParams.containsKey((Object)AbilityKey.LastStateBattlefield)) {
                cardList = (CardCollectionView)runParams.get((Object)AbilityKey.LastStateBattlefield);
            }
            if (cardList == null) {
                cardList = game.getLastStateBattlefield();
            }
        } else {
            cardList = game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES);
        }
        block0: for (Card ca : cardList) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE)) continue;
                if (t2.hasParam("GameActivationLimit") && t2.getActivationsThisGame() + n + 1 >= Integer.parseInt(t2.getParam("GameActivationLimit")) || t2.hasParam("ActivationLimit") && t2.getActivationsThisTurn() + n + 1 >= Integer.parseInt(t2.getParam("ActivationLimit"))) continue block0;
                if (!StaticAbilityPanharmonicon.applyPanharmoniconAbility(stAb, t2, runParams)) continue;
                ++n;
            }
        }
        return n;
    }

    public static boolean applyPanharmoniconAbility(StaticAbility stAb, Trigger trigger, Map<AbilityKey, Object> runParams) {
        Card host = stAb.getHostCard();
        TriggerType trigMode = trigger.getMode();
        if (!stAb.matchesValidParam("ValidCard", trigger.getHostCard())) {
            return false;
        }
        if (stAb.hasParam("ValidMode") && !ArrayUtils.contains(stAb.getParam("ValidMode").split(","), trigMode.toString())) {
            return false;
        }
        List<ZoneType> validZones = ZoneType.listValueOf(stAb.getParamOrDefault("ValidZone", "Battlefield"));
        if (!validZones.contains((Object)trigger.getHostCard().getZone().getZoneType())) {
            return false;
        }
        if (trigMode.equals((Object)TriggerType.ChangesZone)) {
            Card moved = (Card)runParams.get((Object)AbilityKey.Card);
            if ("Battlefield".equals(trigger.getParam("Origin"))) {
                moved = (Card)runParams.get((Object)AbilityKey.CardLKI);
            }
            if (!stAb.matchesValidParam("ValidCause", moved)) {
                return false;
            }
            if (!stAb.matchesValidParam("Origin", runParams.get((Object)AbilityKey.Origin))) {
                return false;
            }
            if (!stAb.matchesValidParam("Destination", runParams.get((Object)AbilityKey.Destination))) {
                return false;
            }
        } else if (trigMode.equals((Object)TriggerType.ChangesZoneAll)) {
            CardCollection causesForStatic;
            CardCollection causesForTrigger;
            String origin = stAb.getParam("Origin");
            String destination = stAb.getParam("Destination");
            CardZoneTable table = (CardZoneTable)runParams.get((Object)AbilityKey.CardsFiltered);
            if (table == null) {
                table = (CardZoneTable)runParams.get((Object)AbilityKey.Cards);
            }
            List<ZoneType> trigOrigin = null;
            List<ZoneType> trigDestination = null;
            if (trigger.hasParam("Destination") && !trigger.getParam("Destination").equals("Any")) {
                trigDestination = ZoneType.listValueOf(trigger.getParam("Destination"));
            }
            if (trigger.hasParam("Origin") && !trigger.getParam("Origin").equals("Any")) {
                trigOrigin = ZoneType.listValueOf(trigger.getParam("Origin"));
            }
            if (Collections.disjoint(causesForTrigger = table.filterCards(trigOrigin, trigDestination, trigger.getParam("ValidCards"), trigger.getHostCard(), trigger), causesForStatic = table.filterCards(origin == null ? null : ImmutableList.of(ZoneType.smartValueOf(origin)), destination == null ? null : ZoneType.listValueOf(destination), stAb.getParam("ValidCause"), host, stAb))) {
                return false;
            }
        } else if (trigMode.equals((Object)TriggerType.Attacks)) {
            if (!stAb.matchesValidParam("ValidCause", runParams.get((Object)AbilityKey.Attacker))) {
                return false;
            }
        } else if (trigMode.equals((Object)TriggerType.AttackersDeclared) || trigMode.equals((Object)TriggerType.AttackersDeclaredOneTarget)) {
            if (!stAb.matchesValidParam("ValidCause", runParams.get((Object)AbilityKey.Attackers))) {
                return false;
            }
        } else if (trigMode.equals((Object)TriggerType.SpellCastOrCopy) || trigMode.equals((Object)TriggerType.SpellCast) || trigMode.equals((Object)TriggerType.SpellCopy)) {
            SpellAbility sa = (SpellAbility)runParams.get((Object)AbilityKey.SpellAbility);
            if (!stAb.matchesValidParam("ValidCause", sa.getHostCard())) {
                return false;
            }
            if (!stAb.matchesValidParam("ValidActivator", sa.getActivatingPlayer())) {
                return false;
            }
        } else if (trigMode.equals((Object)TriggerType.DamageDone) || trigMode.equals((Object)TriggerType.DamageDoneOnce) || trigMode.equals((Object)TriggerType.DamageAll) || trigMode.equals((Object)TriggerType.DamageDealtOnce)) {
            Map dmgMap;
            if (stAb.hasParam("CombatDamage") && stAb.getParam("CombatDamage").equalsIgnoreCase("True") != ((Boolean)runParams.get((Object)AbilityKey.IsCombatDamage)).booleanValue()) {
                return false;
            }
            if (trigMode.equals((Object)TriggerType.DamageDone)) {
                if (!stAb.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.DamageSource))) {
                    return false;
                }
                if (!stAb.matchesValidParam("ValidTarget", runParams.get((Object)AbilityKey.DamageTarget))) {
                    return false;
                }
            }
            if (trigMode.equals((Object)TriggerType.DamageDoneOnce)) {
                if (!stAb.matchesValidParam("ValidTarget", runParams.get((Object)AbilityKey.DamageTarget))) {
                    return false;
                }
                dmgMap = (Map)runParams.get((Object)AbilityKey.DamageMap);
                if (!Iterables.any(dmgMap.keySet(), Predicates.and(GameObjectPredicates.matchesValidParam(stAb, "ValidSource"), GameObjectPredicates.matchesValidParam(trigger, "ValidSource")))) {
                    return false;
                }
            }
            if (trigMode.equals((Object)TriggerType.DamageDealtOnce)) {
                if (!stAb.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.DamageSource))) {
                    return false;
                }
                dmgMap = (Map)runParams.get((Object)AbilityKey.DamageMap);
                if (!Iterables.any(dmgMap.keySet(), Predicates.and(GameObjectPredicates.matchesValidParam(stAb, "ValidTarget"), GameObjectPredicates.matchesValidParam(trigger, "ValidTarget")))) {
                    return false;
                }
            }
            if (trigMode.equals((Object)TriggerType.DamageAll)) {
                CardDamageMap table = (CardDamageMap)runParams.get((Object)AbilityKey.DamageMap);
                table = table.filteredMap(trigger.getParam("ValidSource"), trigger.getParam("ValidTarget"), trigger.getHostCard(), trigger);
                if ((table = table.filteredMap(stAb.getParam("ValidSource"), stAb.getParam("ValidTarget"), host, stAb)).isEmpty()) {
                    return false;
                }
            }
        } else if (trigMode.equals((Object)TriggerType.TurnFaceUp) && !stAb.matchesValidParam("ValidTurned", runParams.get((Object)AbilityKey.Card))) {
            return false;
        }
        return true;
    }
}

