/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityMustBlock {
    static String MODE = "MustBlock";

    public static boolean blocksEachCombatIfAble(Card creature) {
        Game game = creature.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityMustBlock.applyBlocksEachCombatIfAble(stAb, creature)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyBlocksEachCombatIfAble(StaticAbility stAb, Card creature) {
        return stAb.matchesValidParam("ValidCreature", creature);
    }
}

