/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCrewValue {
    static String MODE = "CrewValue";

    public static boolean crewsWithToughness(Card card) {
        Game game = card.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCrewValue.crewsWithToughness(stAb, card)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean crewsWithToughness(StaticAbility stAb, Card card) {
        return stAb.getParam("Value").equals("Toughness") && stAb.matchesValidParam("ValidCard", card);
    }

    public static int getCrewMod(Card card) {
        int i = 0;
        Game game = card.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !stAb.matchesValidParam("ValidCard", card)) continue;
                int t2 = Integer.parseInt(stAb.getParam("Value"));
                i += t2;
            }
        }
        return i;
    }
}

