/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCastWithFlash {
    static String MODE = "CastWithFlash";

    public static boolean anyWithFlashNeedsInfo(SpellAbility sa, Card card, Player activator) {
        Game game = activator.getGame();
        CardCollection allp = new CardCollection(game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES));
        allp.add(card);
        for (Card ca : allp) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCastWithFlash.applyWithFlashNeedsInfo(stAb, sa, card, activator)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean anyWithFlash(SpellAbility sa, Card card, Player activator) {
        Game game = activator.getGame();
        CardCollection allp = new CardCollection(game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES));
        allp.add(card);
        for (Card ca : allp) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCastWithFlash.applyWithFlashAbility(stAb, sa, card, activator)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean commonParts(StaticAbility stAb, SpellAbility sa, Card card, Player activator, boolean skipValidSA) {
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        if (!skipValidSA && !stAb.matchesValidParam("ValidSA", sa)) {
            return false;
        }
        return stAb.matchesValidParam("Caster", activator);
    }

    public static boolean applyWithFlashNeedsInfo(StaticAbility stAb, SpellAbility sa, Card card, Player activator) {
        boolean info = false;
        String validSA = stAb.getParamOrDefault("ValidSA", "");
        if (validSA.contains("IsTargeting") || validSA.contains("XCost")) {
            info = true;
        }
        if (!StaticAbilityCastWithFlash.commonParts(stAb, sa, card, activator, info)) {
            return false;
        }
        return info;
    }

    public static boolean applyWithFlashAbility(StaticAbility stAb, SpellAbility sa, Card card, Player activator) {
        return StaticAbilityCastWithFlash.commonParts(stAb, sa, card, activator, false);
    }
}

