/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCantTransform {
    static String MODE = "CantTransform";

    public static boolean cantTransform(Card card, CardTraitBase cause) {
        Game game = card.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCantTransform.applyCantTransformAbility(stAb, card, cause)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCantTransformAbility(StaticAbility stAb, Card card, CardTraitBase cause) {
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        return !stAb.hasParam("ExceptCause") || !stAb.matchesValidParam("ExceptCause", cause);
    }
}

