/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityIgnoreHexproofShroud;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.Iterator;

public class StaticAbilityCantTarget {
    static String MODE = "CantTarget";

    public static boolean cantTarget(Card card, SpellAbility spellAbility) {
        Game game = card.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCantTarget.applyCantTargetAbility(stAb, card, spellAbility)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean cantTarget(Player player, SpellAbility spellAbility) {
        Game game = player.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCantTarget.applyCantTargetAbility(stAb, player, spellAbility)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCantTargetAbility(StaticAbility stAb, Card card, SpellAbility spellAbility) {
        if (stAb.hasParam("ValidPlayer")) {
            return false;
        }
        if (stAb.hasParam("AffectedZone")) {
            boolean inZone = false;
            for (ZoneType zt : ZoneType.listValueOf(stAb.getParam("AffectedZone"))) {
                if (!card.isInZone(zt)) continue;
                inZone = true;
                break;
            }
            if (!inZone) {
                return false;
            }
        } else if (!card.isInPlay()) {
            return false;
        }
        if ("Stack".equals(stAb.getParam("EffectZone")) && card.getGame().getStack().getSpellMatchingHost(spellAbility.getHostCard()) != null) {
            return false;
        }
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        return StaticAbilityCantTarget.common(stAb, card, spellAbility);
    }

    public static boolean applyCantTargetAbility(StaticAbility stAb, Player player, SpellAbility spellAbility) {
        if (stAb.hasParam("ValidCard") || stAb.hasParam("AffectedZone")) {
            return false;
        }
        if (!stAb.matchesValidParam("ValidPlayer", player)) {
            return false;
        }
        return StaticAbilityCantTarget.common(stAb, player, spellAbility);
    }

    protected static boolean common(StaticAbility stAb, GameEntity entity, SpellAbility spellAbility) {
        Card source = spellAbility.getHostCard();
        Player activator = spellAbility.getActivatingPlayer();
        if (stAb.isKeyword(Keyword.HEXPROOF) && StaticAbilityIgnoreHexproofShroud.ignore(entity, spellAbility, Keyword.HEXPROOF)) {
            return false;
        }
        if (stAb.isKeyword(Keyword.SHROUD) && StaticAbilityIgnoreHexproofShroud.ignore(entity, spellAbility, Keyword.SHROUD)) {
            return false;
        }
        if (!stAb.matchesValidParam("ValidSA", spellAbility)) {
            return false;
        }
        if (!stAb.matchesValidParam("ValidSource", source)) {
            return false;
        }
        if (!stAb.matchesValidParam("Activator", activator)) {
            return false;
        }
        if (stAb.hasParam("SourceCanOnlyTarget")) {
            SpellAbility root = spellAbility.getRootAbility();
            ArrayList<SpellAbility> choices = null;
            choices = root.getApi() == ApiType.Charm ? Lists.newArrayList(root.getAdditionalAbilityList("Choices")) : Lists.newArrayList(root);
            Iterator it = choices.iterator();
            SpellAbility next = (SpellAbility)it.next();
            while (next != null) {
                if (next.usesTargeting() && (!next.getParam("ValidTgts").contains(stAb.getParam("SourceCanOnlyTarget")) || next.getParam("ValidTgts").contains(",") || next.getParam("ValidTgts").contains("non" + stAb.getParam("SourceCanOnlyTarget")))) {
                    return false;
                }
                if ((next = next.getSubAbility()) != null || !it.hasNext()) continue;
                next = (SpellAbility)it.next();
            }
        }
        return true;
    }
}

