/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCantSacrifice {
    static String MODE = "CantSacrifice";

    public static boolean cantSacrifice(Card card, SpellAbility cause, boolean effect) {
        Game game = card.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCantSacrifice.applyCantSacrificeAbility(stAb, card, cause, effect)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCantSacrificeAbility(StaticAbility stAb, Card card, SpellAbility cause, boolean effect) {
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        if (stAb.hasParam("ForCost") && "True".equalsIgnoreCase(stAb.getParam("ForCost")) == effect) {
            return false;
        }
        return stAb.matchesValidParam("ValidCause", cause);
    }
}

