/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCantGainLosePayLife {
    static String MODE_CANT_GAIN_LIFE = "CantGainLife";
    static String MODE_CANT_LOSE_LIFE = "CantLoseLife";
    static String MODE_CANT_CHANGE_LIFE = "CantChangeLife";
    static String MODE_CANT_PAY_LIFE = "CantPayLife";

    public static boolean anyCantGainLife(Player player) {
        Game game = player.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkMode(MODE_CANT_GAIN_LIFE) && !stAb.checkMode(MODE_CANT_CHANGE_LIFE) || !stAb.checkConditions() || !StaticAbilityCantGainLosePayLife.applyCommonAbility(stAb, player)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean anyCantLoseLife(Player player) {
        Game game = player.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkMode(MODE_CANT_LOSE_LIFE) && !stAb.checkMode(MODE_CANT_CHANGE_LIFE) || !stAb.checkConditions() || !StaticAbilityCantGainLosePayLife.applyCommonAbility(stAb, player)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean anyCantPayLife(Player player, boolean effect, SpellAbility cause) {
        Game game = player.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkMode(MODE_CANT_PAY_LIFE) && !stAb.checkMode(MODE_CANT_LOSE_LIFE) && !stAb.checkMode(MODE_CANT_CHANGE_LIFE) || !stAb.checkConditions() || stAb.hasParam("ForCost") && "True".equalsIgnoreCase(stAb.getParam("ForCost")) == effect || !stAb.matchesValidParam("ValidCause", cause) || !StaticAbilityCantGainLosePayLife.applyCommonAbility(stAb, player)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCommonAbility(StaticAbility stAb, Player player) {
        return stAb.matchesValidParam("ValidPlayer", player);
    }
}

