/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCantExile {
    static String MODE = "CantExile";

    public static boolean cantExile(Card card, SpellAbility cause, boolean effect) {
        Game game = card.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCantExile.applyCantExileAbility(stAb, card, cause, effect)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCantExileAbility(StaticAbility stAb, Card card, SpellAbility cause, boolean effect) {
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        if (stAb.hasParam("ForCost") && "True".equalsIgnoreCase(stAb.getParam("ForCost")) == effect) {
            return false;
        }
        return stAb.matchesValidParam("ValidCause", cause);
    }
}

