/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCantDiscard {
    static String MODE = "CantDiscard";

    public static boolean cantDiscard(Player player, SpellAbility cause, boolean effect) {
        Game game = player.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCantDiscard.applyCantDiscardAbility(stAb, player, cause, effect)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCantDiscardAbility(StaticAbility stAb, Player player, SpellAbility cause, boolean effect) {
        if (!stAb.matchesValidParam("ValidPlayer", player)) {
            return false;
        }
        if (stAb.hasParam("ForCost") && "True".equalsIgnoreCase(stAb.getParam("ForCost")) == effect) {
            return false;
        }
        return stAb.matchesValidParam("ValidCause", cause);
    }
}

