/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCanAttackDefender {
    static String MODE = "CanAttackDefender";

    public static boolean canAttack(Card card, GameEntity target) {
        for (Card ca : card.getGame().getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCanAttackDefender.applyCanAttackAbility(stAb, card, target)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCanAttackAbility(StaticAbility stAb, Card card, GameEntity target) {
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        return stAb.matchesValidParam("ValidAttacked", target);
    }
}

